/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.lsmop;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.problem.multiobjective.lsmop.AbstractLSMOP;
import org.uma.jmetal.problem.multiobjective.lsmop.functions.Ackley;
import org.uma.jmetal.problem.multiobjective.lsmop.functions.Function;
import org.uma.jmetal.problem.multiobjective.lsmop.functions.Sphere;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class LSMOP9
extends AbstractLSMOP {
    public LSMOP9() {
        this(5, 300, 3);
    }

    public LSMOP9(int nk, int numberOfVariables, int numberOfObjectives) throws JMetalException {
        super(nk, numberOfVariables, numberOfObjectives);
        this.setName("LSMOP9");
    }

    @Override
    protected Function getOddFunction() {
        return new Sphere();
    }

    @Override
    protected Function getEvenFunction() {
        return new Ackley();
    }

    @Override
    protected List<Double> evaluate(List<Double> variables) {
        int k;
        ArrayList<Double> x;
        int i;
        double[] G = new double[this.getNumberOfObjectives()];
        for (i = this.getNumberOfObjectives(); i <= this.getNumberOfVariables(); ++i) {
            double aux = (1.0 + Math.cos((double)i / (double)this.getNumberOfVariables() * Math.PI / 2.0)) * variables.get(i - 1);
            variables.set(i - 1, aux -= variables.get(0) * 10.0);
        }
        for (i = 0; i < this.getNumberOfObjectives(); ++i) {
            G[i] = 0.0;
        }
        for (i = 1; i <= this.getNumberOfObjectives(); i += 2) {
            for (int j = 1; j <= this.nk; ++j) {
                x = new ArrayList<Double>(this.getNumberOfVariables());
                for (k = (Integer)this.len.get(i - 1) + this.getNumberOfObjectives() - 1 + (j - 1) * (Integer)this.subLen.get(i - 1) + 1; k <= (Integer)this.len.get(i - 1) + this.getNumberOfObjectives() - 1 + j * (Integer)this.subLen.get(i - 1); ++k) {
                    x.add(variables.get(k - 1));
                }
                int n = i - 1;
                G[n] = G[n] + this.getOddFunction().evaluate(x);
            }
        }
        for (i = 2; i <= this.getNumberOfObjectives(); i += 2) {
            for (int j = 1; j <= this.nk; ++j) {
                x = new ArrayList(this.getNumberOfVariables());
                for (k = (Integer)this.len.get(i - 1) + this.getNumberOfObjectives() - 1 + (j - 1) * (Integer)this.subLen.get(i - 1) + 1; k <= (Integer)this.len.get(i - 1) + this.getNumberOfObjectives() - 1 + j * (Integer)this.subLen.get(i - 1); ++k) {
                    x.add(variables.get(k - 1));
                }
                int n = i - 1;
                G[n] = G[n] + this.getEvenFunction().evaluate(x);
            }
        }
        double cofficientG = 0.0;
        for (int i2 = 0; i2 < G.length; ++i2) {
            cofficientG += G[i2] / (double)this.nk;
        }
        cofficientG = 1.0 + cofficientG;
        ArrayList<Double> y = new ArrayList<Double>(this.getNumberOfObjectives());
        for (int i3 = 0; i3 < this.getNumberOfObjectives() - 1; ++i3) {
            y.add(variables.get(i3));
        }
        double sum = 0.0;
        for (int i4 = 1; i4 <= this.getNumberOfObjectives() - 1; ++i4) {
            sum += (Double)y.get(i4 - 1) / (1.0 + cofficientG) * (1.0 + Math.sin(Math.PI * 3 * (Double)y.get(i4 - 1)));
        }
        y.add((1.0 + cofficientG) * ((double)this.getNumberOfObjectives() - sum));
        return y;
    }
}

