/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.maf;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class MaF01
extends AbstractDoubleProblem {
    public MaF01() {
        this(12, 3);
    }

    public MaF01(Integer numberOfVariables, Integer numberOfObjectives) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setNumberOfConstraints(0);
        this.setName("MaF01");
        ArrayList<Double> lower = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upper = new ArrayList<Double>(this.getNumberOfVariables());
        for (int var = 0; var < numberOfVariables; ++var) {
            lower.add(0.0);
            upper.add(1.0);
        }
        this.setVariableBounds(lower, upper);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        int i;
        int numberOfVariables = solution.variables().size();
        int numberOfObjectives = solution.objectives().length;
        double[] x = new double[numberOfVariables];
        double[] f = new double[numberOfObjectives];
        for (int i2 = 0; i2 < numberOfVariables; ++i2) {
            x[i2] = (Double)solution.variables().get(i2);
        }
        double g = 0.0;
        double subf1 = 1.0;
        for (int j = numberOfObjectives - 1; j < numberOfVariables; ++j) {
            g += Math.pow(x[j] - 0.5, 2.0);
        }
        double subf3 = 1.0 + g;
        f[numberOfObjectives - 1] = x[0] * subf3;
        for (i = numberOfObjectives - 2; i > 0; --i) {
            f[i] = subf3 * (1.0 - (subf1 *= x[numberOfObjectives - i - 2]) * (1.0 - x[numberOfObjectives - i - 1]));
        }
        f[0] = (1.0 - subf1 * x[numberOfObjectives - 2]) * subf3;
        for (i = 0; i < numberOfObjectives; ++i) {
            solution.objectives()[i] = f[i];
        }
        return solution;
    }
}

