/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.maf;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class MaF04
extends AbstractDoubleProblem {
    public double[] const4;

    public MaF04() {
        this(12, 3);
    }

    public MaF04(Integer numberOfVariables, Integer numberOfObjectives) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setNumberOfConstraints(0);
        this.setName("MaF04");
        ArrayList<Double> lower = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upper = new ArrayList<Double>(this.getNumberOfVariables());
        for (int var = 0; var < numberOfVariables; ++var) {
            lower.add(0.0);
            upper.add(1.0);
        }
        this.setVariableBounds(lower, upper);
        double[] c4 = new double[numberOfObjectives.intValue()];
        for (int i = 0; i < numberOfObjectives; ++i) {
            c4[i] = Math.pow(2.0, i + 1);
        }
        this.const4 = c4;
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        int i;
        int numberOfVariables = solution.variables().size();
        int numberOfObjectives = solution.objectives().length;
        double[] x = new double[numberOfVariables];
        double[] f = new double[numberOfObjectives];
        for (int i2 = 0; i2 < numberOfVariables; ++i2) {
            x[i2] = (Double)solution.variables().get(i2);
        }
        double g = 0.0;
        for (int i3 = numberOfObjectives - 1; i3 < numberOfVariables; ++i3) {
            g += Math.pow(x[i3] - 0.5, 2.0) - Math.cos(62.83185307179586 * (x[i3] - 0.5));
        }
        g = 100.0 * ((double)(numberOfVariables - numberOfObjectives + 1) + g);
        double subf1 = 1.0;
        double subf3 = 1.0 + g;
        f[numberOfObjectives - 1] = this.const4[numberOfObjectives - 1] * (1.0 - Math.sin(Math.PI * x[0] / 2.0)) * subf3;
        for (i = numberOfObjectives - 2; i > 0; --i) {
            f[i] = this.const4[i] * (1.0 - (subf1 *= Math.cos(Math.PI * x[numberOfObjectives - i - 2] / 2.0)) * Math.sin(Math.PI * x[numberOfObjectives - i - 1] / 2.0)) * subf3;
        }
        f[0] = this.const4[0] * (1.0 - subf1 * Math.cos(Math.PI * x[numberOfObjectives - 2] / 2.0)) * subf3;
        for (i = 0; i < numberOfObjectives; ++i) {
            solution.objectives()[i] = f[i];
        }
        return solution;
    }
}

