/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.maf;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class MaF05
extends AbstractDoubleProblem {
    public double[] const5;

    public MaF05() {
        this(12, 3);
    }

    public MaF05(Integer numberOfVariables, Integer numberOfObjectives) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setNumberOfConstraints(0);
        this.setName("MaF05");
        ArrayList<Double> lower = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upper = new ArrayList<Double>(this.getNumberOfVariables());
        for (int var = 0; var < numberOfVariables; ++var) {
            lower.add(0.0);
            upper.add(1.0);
        }
        this.setVariableBounds(lower, upper);
        double[] c5 = new double[numberOfObjectives.intValue()];
        for (int i = 0; i < numberOfObjectives; ++i) {
            c5[i] = Math.pow(2.0, i + 1);
        }
        this.const5 = c5;
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        int i;
        int numberOfVariables = solution.variables().size();
        int numberOfObjectives = solution.objectives().length;
        double[] x = new double[numberOfVariables];
        double[] f = new double[numberOfObjectives];
        for (int i2 = 0; i2 < numberOfVariables; ++i2) {
            x[i2] = (Double)solution.variables().get(i2);
        }
        double g = 0.0;
        for (int i3 = numberOfObjectives - 1; i3 < numberOfVariables; ++i3) {
            g += Math.pow(x[i3] - 0.5, 2.0);
        }
        double subf1 = 1.0;
        double subf3 = 1.0 + g;
        f[numberOfObjectives - 1] = 2.0 * Math.pow(Math.sin(Math.PI * Math.pow(x[0], 100.0) / 2.0) * subf3, 1.0);
        for (i = numberOfObjectives - 2; i > 0; --i) {
            f[i] = this.const5[numberOfObjectives - i - 1] * Math.pow((subf1 *= Math.cos(Math.PI * Math.pow(x[numberOfObjectives - i - 2], 100.0) / 2.0)) * Math.sin(Math.PI * Math.pow(x[numberOfObjectives - i - 1], 100.0) / 2.0) * subf3, 1.0);
        }
        f[0] = this.const5[numberOfObjectives - 1] * Math.pow(subf1 * Math.cos(Math.PI * Math.pow(x[numberOfObjectives - 2], 100.0) / 2.0) * subf3, 1.0);
        for (i = 0; i < numberOfObjectives; ++i) {
            solution.objectives()[i] = f[i];
        }
        return solution;
    }
}

