/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.maf;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class MaF08
extends AbstractDoubleProblem {
    public double[][] const8;

    public MaF08() {
        this(2, 10);
    }

    public MaF08(Integer numberOfVariables, Integer numberOfObjectives) {
        this.setNumberOfVariables(2);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setNumberOfConstraints(0);
        this.setName("MaF08");
        double r = 1.0;
        this.const8 = MaF08.polygonpoints(numberOfObjectives, r);
        ArrayList<Double> lower = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upper = new ArrayList<Double>(this.getNumberOfVariables());
        for (int var = 0; var < numberOfVariables; ++var) {
            lower.add(-10000.0);
            upper.add(10000.0);
        }
        this.setVariableBounds(lower, upper);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        int i;
        int numberOfVariables = solution.variables().size();
        int numberOfObjectives = solution.objectives().length;
        double[] x = new double[numberOfVariables];
        double[] f = new double[numberOfObjectives];
        for (i = 0; i < numberOfVariables; ++i) {
            x[i] = (Double)solution.variables().get(i);
        }
        for (i = 0; i < numberOfObjectives; ++i) {
            f[i] = Math.sqrt(Math.pow(this.const8[i][0] - x[0], 2.0) + Math.pow(this.const8[i][1] - x[1], 2.0));
        }
        for (i = 0; i < numberOfObjectives; ++i) {
            solution.objectives()[i] = f[i];
        }
        return solution;
    }

    public static double[][] polygonpoints(int m, double r) {
        int i;
        double[] startp = new double[]{0.0, 1.0};
        double[][] p1 = new double[m][2];
        double[][] p = new double[m][2];
        p1[0] = startp;
        for (i = 1; i < m; ++i) {
            p1[i] = MaF08.nextPoint(Math.PI * 2 / (double)m * (double)i, startp, r);
        }
        for (i = 0; i < m; ++i) {
            p[i] = p1[m - i - 1];
        }
        return p;
    }

    public static double[] nextPoint(double arc, double[] startp, double r) {
        double[] p = new double[]{startp[0] - r * Math.sin(arc), r * Math.cos(arc)};
        return p;
    }
}

