/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.maf;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class MaF15
extends AbstractDoubleProblem {
    public int nk15 = 2;
    public int[] sublen15;
    public int[] len15;

    public MaF15() {
        this(60, 3);
    }

    public MaF15(Integer numberOfVariables, Integer numberOfObjectives) {
        int var;
        double[] c = new double[numberOfObjectives.intValue()];
        c[0] = 0.342;
        double sumc = 0.0;
        sumc += c[0];
        for (int i = 1; i < numberOfObjectives; ++i) {
            c[i] = 3.8 * c[i - 1] * (1.0 - c[i - 1]);
            sumc += c[i];
        }
        int[] sublen = new int[numberOfObjectives.intValue()];
        int[] len = new int[numberOfObjectives + 1];
        len[0] = 0;
        for (int i = 0; i < numberOfObjectives; ++i) {
            sublen[i] = (int)Math.ceil((double)Math.round(c[i] / sumc * (double)numberOfVariables.intValue()) / (double)this.nk15);
            len[i + 1] = len[i] + this.nk15 * sublen[i];
        }
        this.sublen15 = sublen;
        this.len15 = len;
        numberOfVariables = numberOfObjectives - 1 + len[numberOfObjectives];
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(numberOfObjectives);
        this.setNumberOfConstraints(0);
        this.setName("MaF15");
        ArrayList<Double> lower = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upper = new ArrayList<Double>(this.getNumberOfVariables());
        for (var = 0; var < numberOfObjectives - 1; ++var) {
            lower.add(0.0);
            upper.add(1.0);
        }
        for (var = numberOfObjectives - 1; var < numberOfVariables; ++var) {
            lower.add(0.0);
            upper.add(10.0);
        }
        this.setVariableBounds(lower, upper);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        int i;
        int j;
        double sub1;
        double[] tx;
        int i2;
        int i3;
        int numberOfVariables = solution.variables().size();
        int numberOfObjectives = solution.objectives().length;
        double[] x = new double[numberOfVariables];
        double[] f = new double[numberOfObjectives];
        for (i3 = 0; i3 < numberOfVariables; ++i3) {
            x[i3] = (Double)solution.variables().get(i3);
        }
        for (i3 = numberOfObjectives - 1; i3 < numberOfVariables; ++i3) {
            x[i3] = (1.0 + Math.cos((double)(i3 + 1) / (double)numberOfVariables * Math.PI / 2.0)) * x[i3] - 10.0 * x[0];
        }
        double[] g = new double[numberOfObjectives];
        for (i2 = 0; i2 < numberOfObjectives; i2 += 2) {
            tx = new double[this.sublen15[i2]];
            sub1 = 0.0;
            for (j = 0; j < this.nk15; ++j) {
                System.arraycopy(x, this.len15[i2] + numberOfObjectives - 1 + j * this.sublen15[i2], tx, 0, this.sublen15[i2]);
                sub1 += MaF15.Griewank(tx);
            }
            g[i2] = sub1 / (double)(this.nk15 * this.sublen15[i2]);
        }
        for (i2 = 1; i2 < numberOfObjectives; i2 += 2) {
            tx = new double[this.sublen15[i2]];
            sub1 = 0.0;
            for (j = 0; j < this.nk15; ++j) {
                System.arraycopy(x, this.len15[i2] + numberOfObjectives - 1 + j * this.sublen15[i2], tx, 0, this.sublen15[i2]);
                sub1 += MaF15.Sphere(tx);
            }
            g[i2] = sub1 / (double)(this.nk15 * this.sublen15[i2]);
        }
        double subf1 = 1.0;
        f[numberOfObjectives - 1] = (1.0 - Math.sin(Math.PI * x[0] / 2.0)) * (1.0 + g[numberOfObjectives - 1]);
        for (i = numberOfObjectives - 2; i > 0; --i) {
            f[i] = (1.0 - (subf1 *= Math.cos(Math.PI * x[numberOfObjectives - i - 2] / 2.0)) * Math.sin(Math.PI * x[numberOfObjectives - i - 1] / 2.0)) * (1.0 + g[i] + g[i + 1]);
        }
        f[0] = (1.0 - subf1 * Math.cos(Math.PI * x[numberOfObjectives - 2] / 2.0)) * (1.0 + g[0] + g[1]);
        for (i = 0; i < numberOfObjectives; ++i) {
            solution.objectives()[i] = f[i];
        }
        return solution;
    }

    public static double Griewank(double[] x) {
        double eta = 0.0;
        double sub1 = 0.0;
        double sub2 = 1.0;
        for (int i = 0; i < x.length; ++i) {
            sub1 += Math.pow(x[i], 2.0) / 4000.0;
            sub2 *= Math.cos(x[i] / Math.sqrt(i + 1));
        }
        eta = sub1 - sub2 + 1.0;
        return eta;
    }

    public static double Sphere(double[] x) {
        double eta = 0.0;
        for (int i = 0; i < x.length; ++i) {
            eta += Math.pow(x[i], 2.0);
        }
        return eta;
    }
}

