/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.mop;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class MOP3
extends AbstractDoubleProblem {
    public MOP3() {
        this(10);
    }

    public MOP3(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setName("MOP3");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double[] f = new double[solution.objectives().length];
        double g = this.evalG(solution);
        f[0] = (1.0 + g) * Math.cos((Double)solution.variables().get(0) * Math.PI * 0.5);
        f[1] = (1.0 + g) * Math.sin((Double)solution.variables().get(0) * Math.PI * 0.5);
        solution.objectives()[0] = f[0];
        solution.objectives()[1] = f[1];
        return solution;
    }

    private double evalG(DoubleSolution solution) {
        double g = 0.0;
        for (int i = 1; i < solution.variables().size(); ++i) {
            double t = (Double)solution.variables().get(i) - Math.sin(1.5707963267948966 * (Double)solution.variables().get(0));
            g += Math.abs(t) / (1.0 + Math.exp(5.0 * Math.abs(t)));
        }
        g = 10.0 * Math.sin(1.5707963267948966 * (Double)solution.variables().get(0)) * g;
        return g;
    }
}

