/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.re;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class RE21
extends AbstractDoubleProblem {
    public RE21() {
        this.setNumberOfVariables(4);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(0);
        this.setName("RE21");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        double f = 10.0;
        double sigma = 10.0;
        double tmpVar = f / sigma;
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            upperLimit.add(3.0 * tmpVar);
        }
        lowerLimit.add(0, tmpVar);
        lowerLimit.add(1, Math.sqrt(2.0) * tmpVar);
        lowerLimit.add(2, Math.sqrt(2.0) * tmpVar);
        lowerLimit.add(3, tmpVar);
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double x1 = (Double)solution.variables().get(0);
        double x2 = (Double)solution.variables().get(1);
        double x3 = (Double)solution.variables().get(2);
        double x4 = (Double)solution.variables().get(3);
        double f = 10.0;
        double e = 200000.0;
        double l = 200.0;
        solution.objectives()[0] = l * (2.0 * x1 + Math.sqrt(2.0) * x2 + Math.sqrt(x3) + x4);
        solution.objectives()[1] = f * l / e * (2.0 / x1 + 2.0 * Math.sqrt(2.0) / x2 - 2.0 * Math.sqrt(2.0) / x3 + 2.0 / x4);
        return solution;
    }
}

