/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.re;

import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.problem.multiobjective.re.Util;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class RE22
extends AbstractDoubleProblem {
    private int numberOfOriginalConstraints = 2;
    private static final double[] asFeasibleIntegers = new double[]{0.2, 0.31, 0.4, 0.44, 0.6, 0.62, 0.79, 0.8, 0.88, 0.93, 1.0, 1.2, 1.24, 1.32, 1.4, 1.55, 1.58, 1.6, 1.76, 1.8, 1.86, 2.0, 2.17, 2.2, 2.37, 2.4, 2.48, 2.6, 2.64, 2.79, 2.8, 3.0, 3.08, 3.0, 10.0, 3.16, 3.41, 3.52, 3.6, 3.72, 3.95, 3.96, 4.0, 4.03, 4.2, 4.34, 4.4, 4.65, 4.74, 4.8, 4.84, 5.0, 5.28, 5.4, 5.53, 5.72, 6.0, 6.16, 6.32, 6.6, 7.11, 7.2, 7.8, 7.9, 8.0, 8.4, 8.69, 9.0, 9.48, 10.27, 11.0, 11.06, 11.85, 12.0, 13.0, 14.0, 15.0};

    public RE22() {
        this.setNumberOfVariables(3);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(0);
        this.setName("RE22");
        List<Double> lowerLimit = List.of(Double.valueOf(0.2), Double.valueOf(0.0), Double.valueOf(0.0));
        List<Double> upperLimit = List.of(Double.valueOf(15.0), Double.valueOf(20.0), Double.valueOf(40.0));
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double x1 = Util.getClosestValue(asFeasibleIntegers, (Double)solution.variables().get(0));
        double x2 = (Double)solution.variables().get(1);
        double x3 = (Double)solution.variables().get(2);
        double[] g = new double[this.numberOfOriginalConstraints];
        g[0] = x1 * x3 - 7.735 * (x1 * x1 / x2) - 180.0;
        g[1] = 4.0 - x3 / x2;
        for (int i = 0; i < this.numberOfOriginalConstraints; ++i) {
            g[i] = g[i] < 0.0 ? -g[i] : 0.0;
        }
        solution.objectives()[0] = 29.4 * x1 + 0.6 * x2 * x3;
        solution.objectives()[1] = g[0] + g[1];
        return solution;
    }
}

