/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.re;

import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class RE23
extends AbstractDoubleProblem {
    private int numberOfOriginalConstraints = 3;

    public RE23() {
        this.setNumberOfVariables(4);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(0);
        this.setName("RE23");
        List<Double> lowerLimit = List.of(Double.valueOf(1.0), Double.valueOf(1.0), Double.valueOf(10.0), Double.valueOf(10.0));
        List<Double> upperLimit = List.of(Double.valueOf(100.0), Double.valueOf(100.0), Double.valueOf(200.0), Double.valueOf(240.0));
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double x1 = 0.0625 * Math.rint((Double)solution.variables().get(0));
        double x2 = 0.0625 * Math.rint((Double)solution.variables().get(1));
        double x3 = (Double)solution.variables().get(2);
        double x4 = (Double)solution.variables().get(3);
        double[] g = new double[this.numberOfOriginalConstraints];
        g[0] = x1 - 0.0193 * x3;
        g[1] = x2 - 0.00954 * x3;
        g[2] = Math.PI * x3 * x3 * x4 + 1.3333333333333333 * (Math.PI * x3 * x3 * x3) - 1296000.0;
        for (int i = 0; i < this.numberOfOriginalConstraints; ++i) {
            g[i] = g[i] < 0.0 ? -g[i] : 0.0;
        }
        solution.objectives()[0] = 0.6224 * x1 * x3 * x4 + 1.7781 * x2 * x3 * x3 + 3.1661 * x1 * x1 * x4 + 19.84 * x1 * x1 * x3;
        solution.objectives()[1] = g[0] + g[1] + g[2];
        return solution;
    }
}

