/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.re;

import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class RE24
extends AbstractDoubleProblem {
    private int numberOfOriginalConstraints = 4;

    public RE24() {
        this.setNumberOfVariables(2);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(0);
        this.setName("RE24");
        List<Double> lowerLimit = List.of(Double.valueOf(0.5), Double.valueOf(0.5));
        List<Double> upperLimit = List.of(Double.valueOf(4.0), Double.valueOf(50.0));
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double x1 = (Double)solution.variables().get(0);
        double x2 = (Double)solution.variables().get(1);
        double e = 700000.0;
        double sigmaBMax = 700.0;
        double tauMax = 450.0;
        double deltaMax = 1.5;
        double sigmaK = e * x1 * x1 / 100.0;
        double sigmaB = 4500.0 / (x1 * x2);
        double tau = 1800.0 / x2;
        double delta = 562000.0 / (e * x1 * x2 * x2);
        double[] g = new double[this.numberOfOriginalConstraints];
        g[0] = 1.0 - sigmaB / sigmaBMax;
        g[1] = 1.0 - tau / tauMax;
        g[2] = 1.0 - delta / deltaMax;
        g[3] = 1.0 - sigmaB / sigmaK;
        for (int i = 0; i < this.numberOfOriginalConstraints; ++i) {
            g[i] = g[i] < 0.0 ? -g[i] : 0.0;
        }
        solution.objectives()[0] = x1 + 120.0 * x2;
        solution.objectives()[1] = g[0] + g[1] + g[2] + g[3];
        return solution;
    }
}

