/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.re;

import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.problem.multiobjective.re.Util;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class RE25
extends AbstractDoubleProblem {
    private int numberOfOriginalConstraints = 6;
    private static final double[] diameterFeasibleIntergers = new double[]{0.009, 0.0095, 0.0104, 0.0118, 0.0128, 0.0132, 0.014, 0.015, 0.0162, 0.0173, 0.018, 0.02, 0.023, 0.025, 0.028, 0.032, 0.035, 0.041, 0.047, 0.054, 0.063, 0.072, 0.08, 0.092, 0.105, 0.12, 0.135, 0.148, 0.162, 0.177, 0.192, 0.207, 0.225, 0.244, 0.263, 0.283, 0.307, 0.331, 0.362, 0.394, 0.4375, 0.5};

    public RE25() {
        this.setNumberOfVariables(3);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(0);
        this.setName("RE25");
        List<Double> lowerLimit = List.of(Double.valueOf(1.0), Double.valueOf(0.6), Double.valueOf(0.09));
        List<Double> upperLimit = List.of(Double.valueOf(70.0), Double.valueOf(3.0), Double.valueOf(0.5));
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double x1 = Math.rint((Double)solution.variables().get(0));
        double x2 = (Double)solution.variables().get(1);
        double x3 = Util.getClosestValue(diameterFeasibleIntergers, (Double)solution.variables().get(2));
        double[] g = new double[this.numberOfOriginalConstraints];
        double cf = (4.0 * (x2 / x3) - 1.0) / (4.0 * (x2 / x3) - 4.0) + 0.615 * x3 / x2;
        double fMax = 1000.0;
        double S = 189000.0;
        double G = 1.15E7;
        double K = G * x3 * x3 * x3 * x3 / (8.0 * x1 * x2 * x2 * x2);
        double lMax = 14.0;
        double lf = fMax / K + 1.05 * (x1 + 2.0) * x3;
        double Fp = 300.0;
        double sigmaP = Fp / K;
        double sigmaPM = 6.0;
        double sigmaW = 1.25;
        g[0] = -(8.0 * cf * fMax * x2 / (Math.PI * x3 * x3 * x3)) + S;
        g[1] = -lf + lMax;
        g[2] = -3.0 + x2 / x3;
        g[3] = -sigmaP + sigmaPM;
        g[4] = -sigmaP - (fMax - Fp) / K - 1.05 * (x1 + 2.0) * x3 + lf;
        g[5] = sigmaW - (fMax - Fp) / K;
        for (int i = 0; i < this.numberOfOriginalConstraints; ++i) {
            g[i] = g[i] < 0.0 ? -g[i] : 0.0;
        }
        solution.objectives()[0] = Math.PI * Math.PI * x2 * x3 * x3 * (x1 + 2.0) / 4.0;
        solution.objectives()[1] = g[0] + g[1] + g[2] + g[3] + g[4] + g[5];
        return solution;
    }
}

