/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.re;

import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class RE31
extends AbstractDoubleProblem {
    private int numberOfOriginalConstraints = 3;

    public RE31() {
        this.setNumberOfVariables(3);
        this.setNumberOfObjectives(3);
        this.setNumberOfConstraints(0);
        this.setName("RE31");
        List<Double> lowerLimit = List.of(Double.valueOf(1.0E-5), Double.valueOf(1.0E-5), Double.valueOf(1.0));
        List<Double> upperLimit = List.of(Double.valueOf(100.0), Double.valueOf(100.0), Double.valueOf(3.0));
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double x1 = (Double)solution.variables().get(0);
        double x2 = (Double)solution.variables().get(1);
        double x3 = (Double)solution.variables().get(2);
        solution.objectives()[0] = x1 * Math.sqrt(16.0 + x3 * x3) + x2 * Math.sqrt(1.0 + x3 * x3);
        solution.objectives()[1] = 20.0 * Math.sqrt(16.0 + x3 * x3) / (x1 * x3);
        double[] g = new double[this.numberOfOriginalConstraints];
        g[0] = 0.1 - solution.objectives()[0];
        g[1] = 100000.0 - solution.objectives()[1];
        g[2] = 100000.0 - 80.0 * Math.sqrt(1.0 + x3 * x3) / (x3 * x2);
        for (int i = 0; i < this.numberOfOriginalConstraints; ++i) {
            g[i] = g[i] < 0.0 ? -g[i] : 0.0;
        }
        solution.objectives()[2] = g[0] + g[1] + g[2];
        return solution;
    }
}

