/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.re;

import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class RE33
extends AbstractDoubleProblem {
    private int numberOfOriginalConstraints = 4;

    public RE33() {
        this.setNumberOfVariables(4);
        this.setNumberOfObjectives(3);
        this.setNumberOfConstraints(0);
        this.setName("RE33");
        List<Double> lowerLimit = List.of(Double.valueOf(55.0), Double.valueOf(75.0), Double.valueOf(1000.0), Double.valueOf(11.0));
        List<Double> upperLimit = List.of(Double.valueOf(80.0), Double.valueOf(110.0), Double.valueOf(3000.0), Double.valueOf(20.0));
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double x1 = (Double)solution.variables().get(0);
        double x2 = (Double)solution.variables().get(1);
        double x3 = (Double)solution.variables().get(2);
        double x4 = (Double)solution.variables().get(3);
        solution.objectives()[0] = 4.9000000000000005E-5 * (x2 * x2 - x1 * x1) * (x4 - 1.0);
        solution.objectives()[1] = 9820000.0 * (x2 * x2 - x1 * x1) / (x3 * x4 * (x2 * x2 * x2 - x1 * x1 * x1));
        double[] g = new double[this.numberOfOriginalConstraints];
        g[0] = x2 - x1 - 20.0;
        g[1] = 0.4 - x3 / (3.14 * (x2 * x2 - x1 * x1));
        g[2] = 1.0 - 0.00222 * x3 * (x2 * x2 * x2 - x1 * x1 * x1) / Math.pow(x2 * x2 - x1 * x1, 2.0);
        g[3] = 0.026600000000000002 * x3 * x4 * (x2 * x2 * x2 - x1 * x1 * x1) / (x2 * x2 - x1 * x1) - 900.0;
        for (int i = 0; i < this.numberOfOriginalConstraints; ++i) {
            g[i] = g[i] < 0.0 ? -g[i] : 0.0;
        }
        solution.objectives()[2] = g[0] + g[1] + g[2] + g[3];
        return solution;
    }
}

