/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.re;

import java.util.List;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class RE36
extends AbstractDoubleProblem {
    private int numberOfOriginalConstraints = 1;

    public RE36() {
        this.setNumberOfVariables(4);
        this.setNumberOfObjectives(3);
        this.setNumberOfConstraints(0);
        this.setName("RE36");
        List<Double> lowerLimit = List.of(Double.valueOf(12.0), Double.valueOf(12.0), Double.valueOf(12.0), Double.valueOf(12.0));
        List<Double> upperLimit = List.of(Double.valueOf(60.0), Double.valueOf(60.0), Double.valueOf(60.0), Double.valueOf(60.0));
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double x1 = Math.rint((Double)solution.variables().get(0));
        double x2 = Math.rint((Double)solution.variables().get(1));
        double x3 = Math.rint((Double)solution.variables().get(2));
        double x4 = Math.rint((Double)solution.variables().get(3));
        solution.objectives()[0] = Math.abs(6.931 - x3 / x1 * (x4 / x2));
        double maxValue = x1;
        if (x2 > maxValue) {
            maxValue = x2;
        }
        if (x3 > maxValue) {
            maxValue = x3;
        }
        if (x4 > maxValue) {
            maxValue = x4;
        }
        solution.objectives()[1] = maxValue;
        double[] g = new double[this.numberOfOriginalConstraints];
        g[0] = 0.5 - solution.objectives()[0] / 6.931;
        for (int i = 0; i < this.numberOfOriginalConstraints; ++i) {
            g[i] = g[i] < 0.0 ? -g[i] : 0.0;
        }
        solution.objectives()[2] = g[0];
        return solution;
    }
}

