/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.wfg;

import org.uma.jmetal.problem.multiobjective.wfg.Shapes;
import org.uma.jmetal.problem.multiobjective.wfg.Transformations;
import org.uma.jmetal.problem.multiobjective.wfg.WFG;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class WFG8
extends WFG {
    public WFG8() {
        this(2, 4, 2);
    }

    public WFG8(Integer k, Integer l, Integer m) {
        super(k, l, m);
        int i;
        this.setName("WFG8");
        this.s = new int[m.intValue()];
        for (i = 0; i < m; ++i) {
            this.s[i] = 2 * (i + 1);
        }
        this.a = new int[m - 1];
        for (i = 0; i < m - 1; ++i) {
            this.a[i] = 1;
        }
    }

    @Override
    public float[] evaluate(float[] z) {
        float[] y = this.normalise(z);
        y = this.t1(y, this.k);
        y = this.t2(y, this.k);
        y = this.t3(y, this.k, this.m);
        float[] result = new float[this.m];
        float[] x = this.calculateX(y);
        for (int m = 1; m <= this.m; ++m) {
            result[m - 1] = (float)this.d * x[this.m - 1] + (float)this.s[m - 1] * new Shapes().concave(x, m);
        }
        return result;
    }

    public float[] t1(float[] z, int k) {
        int i;
        float[] result = new float[z.length];
        float[] w = new float[z.length];
        for (i = 0; i < w.length; ++i) {
            w[i] = 1.0f;
        }
        System.arraycopy(z, 0, result, 0, k);
        for (i = k; i < z.length; ++i) {
            int head = 0;
            int tail = i - 1;
            float[] subZ = this.subVector(z, head, tail);
            float[] subW = this.subVector(w, head, tail);
            float aux = new Transformations().rSum(subZ, subW);
            result[i] = new Transformations().bParam(z[i], aux, 0.019607844f, 0.02f, 50.0f);
        }
        return result;
    }

    public float[] t2(float[] z, int k) {
        float[] result = new float[z.length];
        System.arraycopy(z, 0, result, 0, k);
        for (int i = k; i < z.length; ++i) {
            result[i] = new Transformations().sLinear(z[i], 0.35f);
        }
        return result;
    }

    public float[] t3(float[] z, int k, int M) {
        int i;
        float[] result = new float[M];
        float[] w = new float[z.length];
        for (i = 0; i < z.length; ++i) {
            w[i] = 1.0f;
        }
        for (i = 1; i <= M - 1; ++i) {
            int head = (i - 1) * k / (M - 1) + 1;
            int tail = i * k / (M - 1);
            float[] subZ = this.subVector(z, head - 1, tail - 1);
            float[] subW = this.subVector(w, head - 1, tail - 1);
            result[i - 1] = new Transformations().rSum(subZ, subW);
        }
        int head = k + 1;
        int tail = z.length;
        float[] subZ = this.subVector(z, head - 1, tail - 1);
        float[] subW = this.subVector(w, head - 1, tail - 1);
        result[M - 1] = new Transformations().rSum(subZ, subW);
        return result;
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        int i;
        float[] variables = new float[this.getNumberOfVariables()];
        double[] x = new double[this.getNumberOfVariables()];
        for (i = 0; i < this.getNumberOfVariables(); ++i) {
            x[i] = (Double)solution.variables().get(i);
        }
        for (i = 0; i < this.getNumberOfVariables(); ++i) {
            variables[i] = (float)x[i];
        }
        float[] sol2 = this.evaluate(variables);
        for (int i2 = 0; i2 < sol2.length; ++i2) {
            solution.objectives()[i2] = sol2[i2];
        }
        return solution;
    }
}

