/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.zdt;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class ZDT1
extends AbstractDoubleProblem {
    public ZDT1() {
        this(30);
    }

    public ZDT1(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setName("ZDT1");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double[] f = new double[solution.objectives().length];
        f[0] = (Double)solution.variables().get(0);
        double g = this.evalG(solution);
        double h = this.evalH(f[0], g);
        f[1] = h * g;
        solution.objectives()[0] = f[0];
        solution.objectives()[1] = f[1];
        return solution;
    }

    protected double evalG(DoubleSolution solution) {
        double g = 0.0;
        for (int i = 1; i < solution.variables().size(); ++i) {
            g += ((Double)solution.variables().get(i)).doubleValue();
        }
        double constant = 9.0 / (double)(solution.variables().size() - 1);
        return constant * g + 1.0;
    }

    protected double evalH(double f, double g) {
        double h = 1.0 - Math.sqrt(f / g);
        return h;
    }
}

