/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.zdt;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.uma.jmetal.problem.binaryproblem.impl.AbstractBinaryProblem;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.util.errorchecking.Check;

public class ZDT5
extends AbstractBinaryProblem {
    private List<Integer> bitsPerVariable;

    public ZDT5() {
        this(11);
    }

    public ZDT5(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setName("ZDT5");
        this.bitsPerVariable = new ArrayList<Integer>(numberOfVariables);
        this.bitsPerVariable.add(30);
        for (int var = 1; var < numberOfVariables; ++var) {
            this.bitsPerVariable.add(5);
        }
    }

    @Override
    public List<Integer> getListOfBitsPerVariable() {
        return this.bitsPerVariable;
    }

    @Override
    public int getBitsFromVariable(int index) {
        Check.valueIsInRange(index, 0, this.getNumberOfVariables());
        return this.bitsPerVariable.get(index);
    }

    @Override
    public BinarySolution evaluate(BinarySolution solution) {
        double[] f = new double[solution.objectives().length];
        f[0] = 1.0 + this.u((BitSet)solution.variables().get(0));
        double g = this.evalG(solution);
        double h = this.evalH(f[0], g);
        f[1] = h * g;
        solution.objectives()[0] = f[0];
        solution.objectives()[1] = f[1];
        return solution;
    }

    public double evalG(BinarySolution solution) {
        double res = 0.0;
        for (int i = 1; i < solution.variables().size(); ++i) {
            res += this.evalV(this.u((BitSet)solution.variables().get(i)));
        }
        return res;
    }

    public double evalV(double value) {
        if (value < 5.0) {
            return 2.0 + value;
        }
        return 1.0;
    }

    public double evalH(double f, double g) {
        return 1.0 / f;
    }

    private double u(BitSet bitset) {
        return bitset.cardinality();
    }
}

