/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class Griewank
extends AbstractDoubleProblem {
    public Griewank(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(1);
        this.setNumberOfConstraints(0);
        this.setName("Griewank");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-600.0);
            upperLimit.add(600.0);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        int numberOfVariables = this.getNumberOfVariables();
        double[] x = new double[numberOfVariables];
        for (int i = 0; i < numberOfVariables; ++i) {
            x[i] = (Double)solution.variables().get(i);
        }
        double sum = 0.0;
        double mult = 1.0;
        double d = 4000.0;
        for (int var = 0; var < numberOfVariables; ++var) {
            sum += x[var] * x[var];
            mult *= Math.cos(x[var] / Math.sqrt(var + 1));
        }
        solution.objectives()[0] = 1.0 / d * sum - mult + 1.0;
        return solution;
    }
}

