/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.uma.jmetal.problem.binaryproblem.impl.AbstractBinaryProblem;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.solution.binarysolution.impl.DefaultBinarySolution;
import org.uma.jmetal.util.errorchecking.Check;

public class OneMax
extends AbstractBinaryProblem {
    private int bits;

    public OneMax() {
        this(256);
    }

    public OneMax(Integer numberOfBits) {
        this.setNumberOfVariables(1);
        this.setNumberOfObjectives(1);
        this.setName("OneMax");
        this.bits = numberOfBits;
    }

    @Override
    public int getBitsFromVariable(int index) {
        Check.that(index == 0, "Problem OneMax has only a variable. Index =" + index);
        return this.bits;
    }

    @Override
    public List<Integer> getListOfBitsPerVariable() {
        return Arrays.asList(this.bits);
    }

    @Override
    public BinarySolution createSolution() {
        return new DefaultBinarySolution(this.getListOfBitsPerVariable(), this.getNumberOfObjectives());
    }

    @Override
    public BinarySolution evaluate(BinarySolution solution) {
        int counterOnes = 0;
        BitSet bitset = (BitSet)solution.variables().get(0);
        for (int i = 0; i < bitset.length(); ++i) {
            if (!bitset.get(i)) continue;
            ++counterOnes;
        }
        solution.objectives()[0] = -1.0 * (double)counterOnes;
        return solution;
    }
}

