/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class Rastrigin
extends AbstractDoubleProblem {
    public Rastrigin(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(1);
        this.setNumberOfConstraints(0);
        this.setName("Rastrigin");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-5.12);
            upperLimit.add(5.12);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        int numberOfVariables = this.getNumberOfVariables();
        double[] x = new double[numberOfVariables];
        for (int i = 0; i < numberOfVariables; ++i) {
            x[i] = (Double)solution.variables().get(i);
        }
        double result = 0.0;
        double a2 = 10.0;
        double w = Math.PI * 2;
        for (int i = 0; i < numberOfVariables; ++i) {
            result += x[i] * x[i] - a2 * Math.cos(w * x[i]);
        }
        solution.objectives()[0] = result += a2 * (double)numberOfVariables;
        return solution;
    }
}

