/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective;

import java.util.ArrayList;
import java.util.Iterator;
import org.uma.jmetal.problem.doubleproblem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;

public class Sphere
extends AbstractDoubleProblem {
    public Sphere() {
        this(10);
    }

    public Sphere(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(1);
        this.setName("Sphere");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-5.12);
            upperLimit.add(5.12);
        }
        this.setVariableBounds(lowerLimit, upperLimit);
    }

    @Override
    public DoubleSolution evaluate(DoubleSolution solution) {
        double sum = 0.0;
        Iterator iterator = solution.variables().iterator();
        while (iterator.hasNext()) {
            double v = (Double)iterator.next();
            sum += v * v;
        }
        solution.objectives()[0] = sum;
        return solution;
    }
}

