/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective.cec2005competitioncode;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.HCJob;
import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.TestFunc;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class Benchmark {
    public static final String CEC2005SUPPORTDATADIRECTORY = "cec2005CompetitionResources/supportData";
    private static final String CEC2005Code = "org.uma.jmetal.problem.singleobjective.cec2005competitioncode";
    public static final int NUM_TEST_FUNC = 25;
    public static final String DEFAULT_FILE_BIAS = "cec2005CompetitionResources/supportData/fbias_data.txt";
    public static final String[] test_func_class_names = new String[]{"F01ShiftedSphere", "F02ShiftedSchwefel", "F03ShiftedRotatedHighCondElliptic", "F04ShiftedSchwefelNoise", "F05SchwefelGlobalOptBound", "F06ShiftedRosenbrock", "F07ShiftedRotatedGriewank", "F08ShiftedRotatedAckleyGlobalOptBound", "F09ShiftedRastrigin", "F10ShiftedRotatedRastrigin", "F11ShiftedRotatedWeierstrass", "F12Schwefel", "F13ShiftedExpandedGriewankRosenbrock", "F14ShiftedRotatedExpandedScaffer", "F15HybridComposition1", "F16RotatedHybridComposition1", "F17RotatedHybridComposition1Noise", "F18RotatedHybridComposition2", "F19RotatedHybridComposition2NarrowBasinGlobalOpt", "F20RotatedHybridComposition2GlobalOptBound", "F21RotatedHybridComposition3", "F22RotatedHybridComposition3HighCondNumMatrix", "F23NoncontinuousRotatedHybridComposition3", "F24RotatedHybridComposition4", "F25RotatedHybridComposition4Bound"};
    public static final int MAX_SUPPORT_DIM = 100;
    public static final double PIx2 = Math.PI * 2;
    public static final DecimalFormat scientificFormatter;
    public static final DecimalFormat numberFormatter;
    public static final DecimalFormat percentageFormatter;
    public static final Random random;
    public static final ClassLoader loader;
    static final Class<?>[] test_func_arg_types;
    private static double[] m_iSqrt;
    private double[] m_biases = new double[25];

    public Benchmark() throws JMetalException {
        this(DEFAULT_FILE_BIAS);
    }

    public Benchmark(String file_bias) throws JMetalException {
        m_iSqrt = new double[100];
        Benchmark.loadRowVectorFromFile(file_bias, 25, this.m_biases);
        for (int i = 0; i < 100; ++i) {
            Benchmark.m_iSqrt[i] = Math.sqrt((double)i + 1.0);
        }
    }

    public static void main(String[] args) throws JMetalException {
        Benchmark theBenchmark = new Benchmark();
        theBenchmark.runTest(0);
    }

    public static double sphere(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * x[i];
        }
        return sum;
    }

    public static double sphere_noise(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * x[i];
        }
        return sum *= 1.0 + 0.1 * Math.abs(random.nextGaussian());
    }

    public static double schwefel_102(double[] x) {
        double curr_sum = x[0];
        double outer_sum = curr_sum * curr_sum;
        for (int i = 1; i < x.length; ++i) {
            double prev_sum = curr_sum;
            curr_sum = prev_sum + x[i];
            outer_sum += curr_sum * curr_sum;
        }
        return outer_sum;
    }

    public static double rosenbrock(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < x.length - 1; ++i) {
            double temp1 = x[i] * x[i] - x[i + 1];
            double temp2 = x[i] - 1.0;
            sum += 100.0 * temp1 * temp1 + temp2 * temp2;
        }
        return sum;
    }

    public static double F2(double x, double y) {
        double temp1 = x * x - y;
        double temp2 = x - 1.0;
        return 100.0 * temp1 * temp1 + temp2 * temp2;
    }

    public static double griewank(double[] x) {
        double sum = 0.0;
        double product = 1.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * x[i] / 4000.0;
            product *= Math.cos(x[i] / m_iSqrt[i]);
        }
        return sum - product + 1.0;
    }

    public static double F8(double x) {
        return x * x / 4000.0 - Math.cos(x) + 1.0;
    }

    public static double ackley(double[] x) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum1 += x[i] * x[i];
            sum2 += Math.cos(Math.PI * 2 * x[i]);
        }
        return -20.0 * Math.exp(-0.2 * Math.sqrt(sum1 / (double)x.length)) - Math.exp(sum2 / (double)x.length) + 20.0 + Math.E;
    }

    public static double myRound(double x) {
        return Math.signum(x) * (double)Math.round(Math.abs(x));
    }

    public static double myXRound(double x, double o) {
        return Math.abs(x - o) < 0.5 ? x : Benchmark.myRound(2.0 * x) / 2.0;
    }

    public static double myXRound(double x) {
        return Math.abs(x) < 0.5 ? x : Benchmark.myRound(2.0 * x) / 2.0;
    }

    public static double rastrigin(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * x[i] - 10.0 * Math.cos(Math.PI * 2 * x[i]) + 10.0;
        }
        return sum;
    }

    public static double rastriginNonCont(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double currX = Benchmark.myXRound(x[i]);
            sum += currX * currX - 10.0 * Math.cos(Math.PI * 2 * currX) + 10.0;
        }
        return sum;
    }

    public static double weierstrass(double[] x) {
        return Benchmark.weierstrass(x, 0.5, 3.0, 20);
    }

    public static double weierstrass(double[] x, double a2, double b, int Kmax) {
        double sum1 = 0.0;
        for (int i = 0; i < x.length; ++i) {
            for (int k = 0; k <= Kmax; ++k) {
                sum1 += Math.pow(a2, k) * Math.cos(Math.PI * 2 * Math.pow(b, k) * (x[i] + 0.5));
            }
        }
        double sum2 = 0.0;
        for (int k = 0; k <= Kmax; ++k) {
            sum2 += Math.pow(a2, k) * Math.cos(Math.PI * 2 * Math.pow(b, k) * 0.5);
        }
        return sum1 - sum2 * (double)x.length;
    }

    public static double F8F2(double[] x) {
        double sum = 0.0;
        for (int i = 1; i < x.length; ++i) {
            sum += Benchmark.F8(Benchmark.F2(x[i - 1], x[i]));
        }
        return sum += Benchmark.F8(Benchmark.F2(x[x.length - 1], x[0]));
    }

    public static double ScafferF6(double x, double y) {
        double temp1 = x * x + y * y;
        double temp2 = Math.sin(Math.sqrt(temp1));
        double temp3 = 1.0 + 0.001 * temp1;
        return 0.5 + (temp2 * temp2 - 0.5) / (temp3 * temp3);
    }

    public static double EScafferF6(double[] x) {
        double sum = 0.0;
        for (int i = 1; i < x.length; ++i) {
            sum += Benchmark.ScafferF6(x[i - 1], x[i]);
        }
        return sum += Benchmark.ScafferF6(x[x.length - 1], x[0]);
    }

    public static double EScafferF6NonCont(double[] x) {
        double prevX;
        double sum = 0.0;
        double currX = Benchmark.myXRound(x[0]);
        for (int i = 1; i < x.length; ++i) {
            prevX = currX;
            currX = Benchmark.myXRound(x[i]);
            sum += Benchmark.ScafferF6(prevX, currX);
        }
        prevX = currX;
        currX = Benchmark.myXRound(x[0]);
        return sum += Benchmark.ScafferF6(prevX, currX);
    }

    public static double elliptic(double[] x) {
        double sum = 0.0;
        double a2 = 1000000.0;
        for (int i = 0; i < x.length; ++i) {
            sum += Math.pow(a2, (double)i / (double)(x.length - 1)) * x[i] * x[i];
        }
        return sum;
    }

    public static double hybrid_composition(double[] x, HCJob job) throws JMetalException {
        int i;
        int num_func = job.numberOfBasicFunctions;
        int num_dim = job.numberOfDimensions;
        double wMax = Double.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < num_func; ++i2) {
            double sumSqr = 0.0;
            Benchmark.shift(job.z[i2], x, job.shiftGlobalOptimum[i2]);
            for (int j = 0; j < num_dim; ++j) {
                sumSqr += job.z[i2][j] * job.z[i2][j];
            }
            job.w[i2] = Math.exp(-1.0 * sumSqr / (2.0 * (double)num_dim * job.sigma[i2] * job.sigma[i2]));
            if (!(wMax < job.w[i2])) continue;
            wMax = job.w[i2];
        }
        double wSum = 0.0;
        double w1mMaxPow = 1.0 - Math.pow(wMax, 10.0);
        for (i = 0; i < num_func; ++i) {
            if (job.w[i] != wMax) {
                int n = i;
                job.w[n] = job.w[n] * w1mMaxPow;
            }
            wSum += job.w[i];
        }
        i = 0;
        while (i < num_func) {
            int n = i++;
            job.w[n] = job.w[n] / wSum;
        }
        double sumF = 0.0;
        for (int i3 = 0; i3 < num_func; ++i3) {
            int j = 0;
            while (j < num_dim) {
                double[] dArray = job.z[i3];
                int n = j++;
                dArray[n] = dArray[n] / job.lambda[i3];
            }
            Benchmark.rotate(job.zM[i3], job.z[i3], job.linearTransformationMatrix[i3]);
            sumF += job.w[i3] * (job.C * job.basicFunc(i3, job.zM[i3]) / job.fmax[i3] + job.biases[i3]);
        }
        return sumF;
    }

    public static void shift(double[] results, double[] x, double[] o) {
        for (int i = 0; i < x.length; ++i) {
            results[i] = x[i] - o[i];
        }
    }

    public static void rotate(double[] results, double[] x, double[][] matrix) {
        Benchmark.xA(results, x, matrix);
    }

    public static double xy(double[] x, double[] y) {
        double result = 0.0;
        for (int i = 0; i < x.length; ++i) {
            result += x[i] * y[i];
        }
        return result;
    }

    public static void xA(double[] result, double[] x, double[][] A) {
        for (int i = 0; i < result.length; ++i) {
            result[i] = 0.0;
            for (int j = 0; j < result.length; ++j) {
                int n = i;
                result[n] = result[n] + x[j] * A[j][i];
            }
        }
    }

    public static void Ax(double[] result, double[][] A, double[] x) {
        for (int i = 0; i < result.length; ++i) {
            result[i] = 0.0;
            for (int j = 0; j < result.length; ++j) {
                int n = i;
                result[n] = result[n] + A[i][j] * x[j];
            }
        }
    }

    public static void loadTestDataFromFile(String file, int num_test_points, int test_dimension, double[][] x, double[] f) throws JMetalException {
        try {
            JMetalLogger.logger.info("File bias: " + file);
            BufferedReader brSrc = new BufferedReader(new FileReader(file));
            Benchmark.loadMatrix(brSrc, num_test_points, test_dimension, x);
            Benchmark.loadColumnVector(brSrc, num_test_points, f);
            brSrc.close();
        }
        catch (Exception e) {
            JMetalLogger.logger.log(Level.SEVERE, "Error in Benchmark.java", e);
            throw new JMetalException("Error in Benchmark.java");
        }
    }

    public static void loadRowVectorFromFile(String file, int columns, double[] row) throws JMetalException {
        try {
            BufferedReader brSrc = new BufferedReader(new InputStreamReader(new FileInputStream(ClassLoader.getSystemResource(file).getPath())));
            Benchmark.loadRowVector(brSrc, columns, row);
            brSrc.close();
        }
        catch (Exception e) {
            JMetalLogger.logger.log(Level.SEVERE, "Error in Benchmark.java", e);
            throw new JMetalException("Error in Benchmark.java");
        }
    }

    public static void loadRowVector(BufferedReader brSrc, int columns, double[] row) throws Exception {
        StringTokenizer stTokenizer = new StringTokenizer(brSrc.readLine());
        for (int i = 0; i < columns; ++i) {
            String stToken = stTokenizer.nextToken();
            row[i] = Double.parseDouble(stToken);
        }
    }

    public static void loadColumnVectorFromFile(String file, int rows, double[] column) throws JMetalException {
        try {
            BufferedReader brSrc = new BufferedReader(new InputStreamReader(new FileInputStream(ClassLoader.getSystemResource(file).getPath())));
            Benchmark.loadColumnVector(brSrc, rows, column);
            brSrc.close();
        }
        catch (Exception e) {
            JMetalLogger.logger.log(Level.SEVERE, "Error in Benchmark.java", e);
            throw new JMetalException("Error in Benchmark.java");
        }
    }

    public static void loadColumnVector(BufferedReader brSrc, int rows, double[] column) throws Exception {
        for (int i = 0; i < rows; ++i) {
            StringTokenizer stTokenizer = new StringTokenizer(brSrc.readLine());
            String stToken = stTokenizer.nextToken();
            column[i] = Double.parseDouble(stToken);
        }
    }

    public static void loadNMatrixFromFile(String file, int N, int rows, int columns, double[][][] matrix) throws JMetalException {
        try {
            BufferedReader brSrc = new BufferedReader(new InputStreamReader(new FileInputStream(ClassLoader.getSystemResource(file).getPath())));
            for (int i = 0; i < N; ++i) {
                Benchmark.loadMatrix(brSrc, rows, columns, matrix[i]);
            }
            brSrc.close();
        }
        catch (Exception e) {
            throw new JMetalException("Error in Benchmark.java", e);
        }
    }

    public static void loadMatrixFromFile(String file, int rows, int columns, double[][] matrix) throws JMetalException {
        try {
            BufferedReader brSrc = new BufferedReader(new InputStreamReader(new FileInputStream(ClassLoader.getSystemResource(file).getPath())));
            Benchmark.loadMatrix(brSrc, rows, columns, matrix);
            brSrc.close();
        }
        catch (Exception e) {
            throw new JMetalException("Error in Benchmark.java", e);
        }
    }

    public static void loadMatrix(BufferedReader brSrc, int rows, int columns, double[][] matrix) throws Exception {
        for (int i = 0; i < rows; ++i) {
            Benchmark.loadRowVector(brSrc, columns, matrix[i]);
        }
    }

    public TestFunc testFunctionFactory(int func_num, int dimension) throws JMetalException {
        TestFunc returnFunc = null;
        try {
            returnFunc = (TestFunc)loader.loadClass("org.uma.jmetal.problem.singleobjective.cec2005competitioncode." + test_func_class_names[func_num - 1]).getConstructor(test_func_arg_types).newInstance(dimension, this.m_biases[func_num - 1]);
        }
        catch (Exception e) {
            throw new JMetalException("Error in Benchmark.java", e);
        }
        return returnFunc;
    }

    public void runTest() throws JMetalException {
        this.runTest(0);
    }

    public void runTest(int func_num) throws JMetalException {
        if (func_num == 0) {
            for (int i = 1; i <= 25; ++i) {
                this.runTest(i);
            }
        } else {
            if (func_num < 0 || func_num > 25) {
                throw new JMetalException("The specified func_num is out of range.");
            }
            int num_test_points = 10;
            int test_dimension = 50;
            double[] test_f = new double[num_test_points];
            double[][] test_x = new double[num_test_points][test_dimension];
            String file_test = "testData/test_data_func" + func_num + ".txt";
            TestFunc aFunc = this.testFunctionFactory(func_num, test_dimension);
            JMetalLogger.logger.info("Run tests on function " + func_num + " (" + aFunc.name() + "):");
            JMetalLogger.logger.info("  " + num_test_points + " " + aFunc.dimension() + "-dimension check points");
            Benchmark.loadTestDataFromFile(file_test, num_test_points, test_dimension, test_x, test_f);
            for (int i = 0; i < num_test_points; ++i) {
                double result = aFunc.f(test_x[i]);
                double diff = result - test_f[i];
                double ratio = Math.abs(diff / test_f[i]);
                JMetalLogger.logger.info("    " + numberFormatter.format(result) + " - " + numberFormatter.format(test_f[i]) + " = " + numberFormatter.format(diff));
                JMetalLogger.logger.info("        Difference ratio = " + numberFormatter.format(ratio));
                if (ratio != 0.0) {
                    if (ratio <= 1.0E-12) {
                        JMetalLogger.logger.info(" (<= 1E-12)");
                        continue;
                    }
                    JMetalLogger.logger.info(" (> 1E-12) *****");
                    continue;
                }
                JMetalLogger.logger.info("");
            }
        }
    }

    static {
        numberFormatter = scientificFormatter = new DecimalFormat("0.0000000000000000E00");
        percentageFormatter = new DecimalFormat("0.0000000000");
        random = new Random();
        loader = ClassLoader.getSystemClassLoader();
        test_func_arg_types = new Class[]{Integer.TYPE, Double.TYPE};
    }
}

