/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective.cec2005competitioncode;

import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.Benchmark;
import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.TestFunc;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class F01ShiftedSphere
extends TestFunc {
    public static final String FUNCTION_NAME = "Shifted Sphere Function";
    public static final String DEFAULT_FILE_DATA = "cec2005CompetitionResources/supportData/sphere_func_data.txt";
    private final double[] shiftedGlobalOptimum;
    private double[] memoryBuffer;

    public F01ShiftedSphere(int dimension, double bias) throws JMetalException {
        this(dimension, bias, DEFAULT_FILE_DATA);
    }

    public F01ShiftedSphere(int dimension, double bias, String file_data) throws JMetalException {
        super(dimension, bias, FUNCTION_NAME);
        this.shiftedGlobalOptimum = new double[this.mDimension];
        this.memoryBuffer = new double[this.mDimension];
        Benchmark.loadRowVectorFromFile(file_data, this.mDimension, this.shiftedGlobalOptimum);
    }

    @Override
    public double f(double[] x) {
        double result = 0.0;
        Benchmark.shift(this.memoryBuffer, x, this.shiftedGlobalOptimum);
        result = Benchmark.sphere(this.memoryBuffer);
        return result += this.mBias;
    }
}

