/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective.cec2005competitioncode;

import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.Benchmark;
import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.TestFunc;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class F05SchwefelGlobalOptBound
extends TestFunc {
    public static final String FUNCTION_NAME = "Schwefel's Problem 2.6 with Global Optimum on Bounds";
    public static final String DEFAULT_FILE_DATA = "cec2005CompetitionResources/supportData/schwefel_206_data.txt";
    private final double[] m_o;
    private final double[][] m_A;
    private double[] m_B;
    private double[] m_z;

    public F05SchwefelGlobalOptBound(int dimension, double bias) throws JMetalException {
        this(dimension, bias, DEFAULT_FILE_DATA);
    }

    public F05SchwefelGlobalOptBound(int dimension, double bias, String file_data) throws JMetalException {
        super(dimension, bias, FUNCTION_NAME);
        int i;
        this.m_o = new double[this.mDimension];
        this.m_A = new double[this.mDimension][this.mDimension];
        this.m_B = new double[this.mDimension];
        this.m_z = new double[this.mDimension];
        double[][] m_data = new double[this.mDimension + 1][this.mDimension];
        Benchmark.loadMatrixFromFile(file_data, this.mDimension + 1, this.mDimension, m_data);
        for (i = 0; i < this.mDimension; ++i) {
            this.m_o[i] = (double)(i + 1) <= Math.ceil((double)this.mDimension / 4.0) ? -100.0 : ((double)(i + 1) >= Math.floor(3.0 * (double)this.mDimension / 4.0) ? 100.0 : m_data[0][i]);
        }
        for (i = 0; i < this.mDimension; ++i) {
            System.arraycopy(m_data[i + 1], 0, this.m_A[i], 0, this.mDimension);
        }
        Benchmark.Ax(this.m_B, this.m_A, this.m_o);
    }

    @Override
    public double f(double[] x) {
        double max = Double.NEGATIVE_INFINITY;
        Benchmark.Ax(this.m_z, this.m_A, x);
        for (int i = 0; i < this.mDimension; ++i) {
            double temp = Math.abs(this.m_z[i] - this.m_B[i]);
            if (!(max < temp)) continue;
            max = temp;
        }
        return max + this.mBias;
    }
}

