/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective.cec2005competitioncode;

import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.Benchmark;
import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.TestFunc;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class F06ShiftedRosenbrock
extends TestFunc {
    public static final String FUNCTION_NAME = "Shifted Rosenbrock's Function";
    public static final String DEFAULT_FILE_DATA = "cec2005CompetitionResources/supportData/rosenbrock_func_data.txt";
    private final double[] m_o;
    private double[] m_z;

    public F06ShiftedRosenbrock(int dimension, double bias) throws JMetalException {
        this(dimension, bias, DEFAULT_FILE_DATA);
    }

    public F06ShiftedRosenbrock(int dimension, double bias, String file_data) throws JMetalException {
        super(dimension, bias, FUNCTION_NAME);
        this.m_o = new double[this.mDimension];
        this.m_z = new double[this.mDimension];
        Benchmark.loadRowVectorFromFile(file_data, this.mDimension, this.m_o);
        int i = 0;
        while (i < this.mDimension) {
            int n = i++;
            this.m_o[n] = this.m_o[n] - 1.0;
        }
    }

    @Override
    public double f(double[] x) {
        double result = 0.0;
        Benchmark.shift(this.m_z, x, this.m_o);
        result = Benchmark.rosenbrock(this.m_z);
        return result += this.mBias;
    }
}

