/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective.cec2005competitioncode;

import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.Benchmark;
import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.TestFunc;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class F12Schwefel
extends TestFunc {
    public static final String FUNCTION_NAME = "Schwefel's Problem 2.13";
    public static final String DEFAULT_FILE_DATA = "cec2005CompetitionResources/supportData/supportData/schwefel_213_data.txt";
    private final double[] m_o;
    private final double[][] m_a;
    private final double[][] m_b;
    private double[] m_A;
    private double[] m_B;

    public F12Schwefel(int dimension, double bias) throws JMetalException {
        this(dimension, bias, DEFAULT_FILE_DATA);
    }

    public F12Schwefel(int dimension, double bias, String file_data) throws JMetalException {
        super(dimension, bias, FUNCTION_NAME);
        int j;
        int i;
        this.m_o = new double[this.mDimension];
        this.m_a = new double[this.mDimension][this.mDimension];
        this.m_b = new double[this.mDimension][this.mDimension];
        this.m_A = new double[this.mDimension];
        this.m_B = new double[this.mDimension];
        double[][] m_data = new double[201][this.mDimension];
        Benchmark.loadMatrixFromFile(file_data, m_data.length, this.mDimension, m_data);
        for (i = 0; i < this.mDimension; ++i) {
            for (j = 0; j < this.mDimension; ++j) {
                this.m_a[i][j] = m_data[i][j];
                this.m_b[i][j] = m_data[100 + i][j];
            }
            this.m_o[i] = m_data[200][i];
        }
        for (i = 0; i < this.mDimension; ++i) {
            this.m_A[i] = 0.0;
            for (j = 0; j < this.mDimension; ++j) {
                int n = i;
                this.m_A[n] = this.m_A[n] + (this.m_a[i][j] * Math.sin(this.m_o[j]) + this.m_b[i][j] * Math.cos(this.m_o[j]));
            }
        }
    }

    @Override
    public double f(double[] x) {
        double sum = 0.0;
        for (int i = 0; i < this.mDimension; ++i) {
            this.m_B[i] = 0.0;
            for (int j = 0; j < this.mDimension; ++j) {
                int n = i;
                this.m_B[n] = this.m_B[n] + (this.m_a[i][j] * Math.sin(x[j]) + this.m_b[i][j] * Math.cos(x[j]));
            }
            double temp = this.m_A[i] - this.m_B[i];
            sum += temp * temp;
        }
        return sum + this.mBias;
    }
}

