/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective.cec2005competitioncode;

import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.Benchmark;
import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.HCJob;
import org.uma.jmetal.problem.singleobjective.cec2005competitioncode.TestFunc;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class F18RotatedHybridComposition2
extends TestFunc {
    public static final String FUNCTION_NAME = "Rotated Hybrid Composition Function 2";
    public static final String DEFAULT_FILE_DATA = "cec2005CompetitionResources/supportData/hybrid_func2_data.txt";
    public static final String DEFAULT_FILE_MX_PREFIX = "cec2005CompetitionResources/supportData/hybrid_func2_M_D";
    public static final String DEFAULT_FILE_MX_SUFFIX = ".txt";
    public static final int NUM_FUNC = 10;
    private final MyHCJob theJob = new MyHCJob();
    private final double[][] m_o;
    private final double[][][] m_M;
    private final double[] m_sigma = new double[]{1.0, 2.0, 1.5, 1.5, 1.0, 1.0, 1.5, 1.5, 2.0, 2.0};
    private final double[] m_lambda = new double[]{0.3125, 0.15625, 2.0, 1.0, 0.1, 0.05, 20.0, 10.0, 0.16666666666666666, 0.08333333333333333};
    private final double[] m_func_biases = new double[]{0.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0};
    private final double[] m_testPoint;
    private final double[] m_testPointM;
    private final double[] m_fmax;
    private double[] m_w;
    private double[][] m_z;
    private double[][] m_zM;

    public F18RotatedHybridComposition2(int dimension, double bias) throws JMetalException {
        this(dimension, bias, DEFAULT_FILE_DATA, DEFAULT_FILE_MX_PREFIX + dimension + DEFAULT_FILE_MX_SUFFIX);
    }

    public F18RotatedHybridComposition2(int dimension, double bias, String file_data, String file_m) throws JMetalException {
        super(dimension, bias, FUNCTION_NAME);
        int i;
        this.m_o = new double[10][this.mDimension];
        this.m_M = new double[10][this.mDimension][this.mDimension];
        this.m_testPoint = new double[this.mDimension];
        this.m_testPointM = new double[this.mDimension];
        this.m_fmax = new double[10];
        this.m_w = new double[10];
        this.m_z = new double[10][this.mDimension];
        this.m_zM = new double[10][this.mDimension];
        Benchmark.loadMatrixFromFile(file_data, 10, this.mDimension, this.m_o);
        for (i = 0; i < this.mDimension; ++i) {
            this.m_o[9][i] = 0.0;
        }
        Benchmark.loadNMatrixFromFile(file_m, 10, this.mDimension, this.mDimension, this.m_M);
        this.theJob.numberOfBasicFunctions = 10;
        this.theJob.numberOfDimensions = this.mDimension;
        this.theJob.C = 2000.0;
        this.theJob.sigma = this.m_sigma;
        this.theJob.biases = this.m_func_biases;
        this.theJob.lambda = this.m_lambda;
        this.theJob.shiftGlobalOptimum = this.m_o;
        this.theJob.linearTransformationMatrix = this.m_M;
        this.theJob.w = this.m_w;
        this.theJob.z = this.m_z;
        this.theJob.zM = this.m_zM;
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < this.mDimension; ++j) {
                this.m_testPoint[j] = 5.0 / this.m_lambda[i];
            }
            Benchmark.rotate(this.m_testPointM, this.m_testPoint, this.m_M[i]);
            this.m_fmax[i] = Math.abs(this.theJob.basicFunc(i, this.m_testPointM));
        }
        this.theJob.fmax = this.m_fmax;
    }

    @Override
    public double f(double[] x) throws JMetalException {
        double result = 0.0;
        result = Benchmark.hybrid_composition(x, this.theJob);
        return result += this.mBias;
    }

    private class MyHCJob
    extends HCJob {
        private MyHCJob() {
        }

        @Override
        public double basicFunc(int func_no, double[] x) throws JMetalException {
            double result = 0.0;
            switch (func_no) {
                case 0: 
                case 1: {
                    result = Benchmark.ackley(x);
                    break;
                }
                case 2: 
                case 3: {
                    result = Benchmark.rastrigin(x);
                    break;
                }
                case 4: 
                case 5: {
                    result = Benchmark.sphere(x);
                    break;
                }
                case 6: 
                case 7: {
                    result = Benchmark.weierstrass(x);
                    break;
                }
                case 8: 
                case 9: {
                    result = Benchmark.griewank(x);
                    break;
                }
                default: {
                    throw new JMetalException("func_no is out of range.");
                }
            }
            return result;
        }
    }
}

