/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.qualityindicator.impl.hypervolume.Hypervolume;
import org.uma.jmetal.qualityindicator.impl.hypervolume.impl.PISAHypervolume;

public class NormalizedHypervolume
extends QualityIndicator {
    private double referenceFrontHypervolume;
    private Hypervolume hypervolume;

    public NormalizedHypervolume() {
    }

    public NormalizedHypervolume(double[] referencePoint) {
        double[][] referenceFront = new double[][]{referencePoint};
        this.hypervolume = new PISAHypervolume(referenceFront);
        this.referenceFrontHypervolume = this.hypervolume.compute(referenceFront);
    }

    public NormalizedHypervolume(double[][] referenceFront) {
        super(referenceFront);
        this.hypervolume = new PISAHypervolume(referenceFront);
        this.referenceFrontHypervolume = this.hypervolume.compute(referenceFront);
    }

    @Override
    public void setReferenceFront(double[][] referenceFront) {
        super.setReferenceFront(referenceFront);
        this.hypervolume = new PISAHypervolume(referenceFront);
        this.referenceFrontHypervolume = this.hypervolume.compute(referenceFront);
    }

    @Override
    public String getName() {
        return "NHV";
    }

    @Override
    public String getDescription() {
        return "Normalized hypervolume";
    }

    @Override
    public boolean isTheLowerTheIndicatorValueTheBetter() {
        return true;
    }

    @Override
    public double compute(double[][] front) {
        double hypervolumeValue = this.hypervolume.compute(front);
        return 1.0 - hypervolumeValue / this.referenceFrontHypervolume;
    }
}

