/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.JMetalException;

public abstract class AbstractSolution<T>
implements Solution<T> {
    private double[] objectives;
    private List<T> variables;
    private double[] constraints;
    protected Map<Object, Object> attributes = new HashMap<Object, Object>();

    @Override
    public List<T> variables() {
        return this.variables;
    }

    @Override
    public double[] objectives() {
        return this.objectives;
    }

    @Override
    public double[] constraints() {
        return this.constraints;
    }

    @Override
    public Map<Object, Object> attributes() {
        return this.attributes;
    }

    protected AbstractSolution(int numberOfVariables, int numberOfObjectives) {
        this(numberOfVariables, numberOfObjectives, 0);
    }

    protected AbstractSolution(int numberOfVariables, int numberOfObjectives, int numberOfConstraints) {
        int i;
        this.variables = new ArrayList<T>(numberOfVariables);
        for (i = 0; i < numberOfVariables; ++i) {
            this.variables.add(i, null);
        }
        this.objectives = new double[numberOfObjectives];
        for (i = 0; i < numberOfObjectives; ++i) {
            this.objectives[i] = 0.0;
        }
        this.constraints = new double[numberOfConstraints];
        for (i = 0; i < numberOfConstraints; ++i) {
            this.constraints[i] = 0.0;
        }
        this.attributes = new HashMap<Object, Object>();
    }

    public String toString() {
        Double obj;
        int n;
        StringBuilder result = new StringBuilder("Variables: ");
        for (T var : this.variables) {
            result.append(var).append(" ");
        }
        result.append("Objectives: ");
        Object object = this.objectives;
        int n2 = ((Object)object).length;
        for (n = 0; n < n2; ++n) {
            obj = (double)object[n];
            result.append(obj).append(" ");
        }
        result.append("Constraints: ");
        object = this.constraints;
        n2 = ((Object)object).length;
        for (n = 0; n < n2; ++n) {
            obj = (double)object[n];
            result.append(obj).append(" ");
        }
        result.append("\t");
        result.append("AlgorithmAttributes: ").append(this.attributes).append("\n");
        return result.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            throw new JMetalException("The solution to compare is null");
        }
        Solution solution = (Solution)o;
        return this.variables().equals(solution.variables());
    }

    public int hashCode() {
        return this.variables.hashCode();
    }
}

