/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.binarysolution.impl;

import java.util.HashMap;
import java.util.List;
import org.uma.jmetal.solution.AbstractSolution;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.util.binarySet.BinarySet;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class DefaultBinarySolution
extends AbstractSolution<BinarySet>
implements BinarySolution {
    protected List<Integer> bitsPerVariable;

    public DefaultBinarySolution(List<Integer> bitsPerVariable, int numberOfObjectives) {
        this(bitsPerVariable, numberOfObjectives, 0);
    }

    public DefaultBinarySolution(List<Integer> bitsPerVariable, int numberOfObjectives, int numberOfConstraints) {
        super(bitsPerVariable.size(), numberOfObjectives, numberOfConstraints);
        this.bitsPerVariable = bitsPerVariable;
        this.initializeBinaryVariables(JMetalRandom.getInstance());
    }

    public DefaultBinarySolution(DefaultBinarySolution solution) {
        super(solution.variables().size(), solution.objectives().length, solution.constraints().length);
        int i;
        this.bitsPerVariable = solution.bitsPerVariable;
        for (i = 0; i < this.variables().size(); ++i) {
            this.variables().set(i, (BinarySet)((BinarySet)solution.variables().get(i)).clone());
        }
        for (i = 0; i < this.objectives().length; ++i) {
            this.objectives()[i] = solution.objectives()[i];
        }
        for (i = 0; i < this.constraints().length; ++i) {
            this.constraints()[i] = solution.constraints()[i];
        }
        this.attributes = new HashMap(solution.attributes);
    }

    private static BinarySet createNewBinarySet(int numberOfBits, JMetalRandom randomGenerator) {
        BinarySet bitSet = new BinarySet(numberOfBits);
        for (int i = 0; i < numberOfBits; ++i) {
            double rnd = randomGenerator.nextDouble();
            if (rnd < 0.5) {
                bitSet.set(i);
                continue;
            }
            bitSet.clear(i);
        }
        return bitSet;
    }

    @Override
    public int getNumberOfBits(int index) {
        return ((BinarySet)this.variables().get(index)).getBinarySetLength();
    }

    public DefaultBinarySolution copy() {
        return new DefaultBinarySolution(this);
    }

    @Override
    public int getTotalNumberOfBits() {
        int sum = 0;
        for (int i = 0; i < this.variables().size(); ++i) {
            sum += ((BinarySet)this.variables().get(i)).getBinarySetLength();
        }
        return sum;
    }

    private void initializeBinaryVariables(JMetalRandom randomGenerator) {
        for (int i = 0; i < this.variables().size(); ++i) {
            this.variables().set(i, DefaultBinarySolution.createNewBinarySet(this.bitsPerVariable.get(i), randomGenerator));
        }
    }
}

