/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.compositesolution;

import java.util.HashMap;
import java.util.List;
import org.uma.jmetal.solution.AbstractSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.Check;

public class CompositeSolution
extends AbstractSolution<Solution<?>> {
    public CompositeSolution(List<Solution<?>> solutions) {
        super(solutions.size(), solutions.get(0).objectives().length, solutions.get(0).constraints().length);
        Check.notNull(solutions);
        Check.collectionIsNotEmpty(solutions);
        int numberOfObjectives = solutions.get(0).objectives().length;
        int numberOfConstraints = solutions.get(0).constraints().length;
        for (Solution<?> solution : solutions) {
            Check.that(solution.objectives().length == numberOfObjectives, "The solutions in the list must have the same number of objectives: " + numberOfObjectives);
            Check.that(solution.constraints().length == numberOfConstraints, "The solutions in the list must have the same number of constraints: " + numberOfConstraints);
        }
        for (int i = 0; i < solutions.size(); ++i) {
            this.variables().set(i, solutions.get(i));
        }
    }

    public CompositeSolution(CompositeSolution solution) {
        super(solution.variables().size(), solution.objectives().length, solution.constraints().length);
        int i;
        for (i = 0; i < solution.variables().size(); ++i) {
            this.variables().set(i, ((Solution)solution.variables().get(i)).copy());
        }
        for (i = 0; i < solution.objectives().length; ++i) {
            this.objectives()[i] = solution.objectives()[i];
        }
        for (i = 0; i < solution.constraints().length; ++i) {
            this.constraints()[i] = solution.constraints()[i];
        }
        this.attributes = new HashMap(solution.attributes);
    }

    @Override
    public Solution<Solution<?>> copy() {
        return new CompositeSolution(this);
    }
}

