/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.permutationsolution.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.uma.jmetal.solution.AbstractSolution;
import org.uma.jmetal.solution.permutationsolution.PermutationSolution;

public class IntegerPermutationSolution
extends AbstractSolution<Integer>
implements PermutationSolution<Integer> {
    public IntegerPermutationSolution(int permutationLength, int numberOfObjectives) {
        super(permutationLength, numberOfObjectives);
        ArrayList<Integer> randomSequence = new ArrayList<Integer>(permutationLength);
        for (int j = 0; j < permutationLength; ++j) {
            randomSequence.add(j);
        }
        Collections.shuffle(randomSequence);
        for (int i = 0; i < permutationLength; ++i) {
            this.variables().set(i, (Integer)randomSequence.get(i));
        }
    }

    public IntegerPermutationSolution(IntegerPermutationSolution solution) {
        super(solution.getLength(), solution.objectives().length);
        int i;
        for (i = 0; i < this.objectives().length; ++i) {
            this.objectives()[i] = solution.objectives()[i];
        }
        for (i = 0; i < this.variables().size(); ++i) {
            this.variables().set(i, (Integer)solution.variables().get(i));
        }
        for (i = 0; i < this.constraints().length; ++i) {
            this.constraints()[i] = solution.constraints()[i];
        }
        this.attributes = new HashMap(solution.attributes);
    }

    public IntegerPermutationSolution copy() {
        return new IntegerPermutationSolution(this);
    }

    @Override
    public int getLength() {
        return this.variables().size();
    }
}

