/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.Check;

public class ConstraintHandling {
    public static <S extends Solution<?>> boolean isFeasible(S solution) {
        return ConstraintHandling.numberOfViolatedConstraints(solution) == 0;
    }

    public static <S extends Solution<?>> int numberOfViolatedConstraints(S solution) {
        int result = 0;
        for (int i = 0; i < solution.constraints().length; ++i) {
            if (!(solution.constraints()[i] < 0.0)) continue;
            ++result;
        }
        return result;
    }

    public static <S extends Solution<?>> double overallConstraintViolationDegree(S solution) {
        double overallConstraintViolation = 0.0;
        for (int i = 0; i < solution.constraints().length; ++i) {
            if (!(solution.constraints()[i] < 0.0)) continue;
            overallConstraintViolation += solution.constraints()[i];
        }
        return overallConstraintViolation;
    }

    public static <S extends Solution<?>> double feasibilityRatio(List<S> solutions) {
        Check.collectionIsNotEmpty(solutions);
        double result = 0.0;
        for (Solution solution : solutions) {
            if (!ConstraintHandling.isFeasible(solution)) continue;
            result += 1.0;
        }
        return result / (double)solutions.size();
    }
}

