/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.util.attribute.util.attributecomparator.AttributeComparator;
import org.uma.jmetal.solution.util.attribute.util.attributecomparator.impl.DoubleValueAttributeComparator;
import org.uma.jmetal.util.SolutionUtils;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.distance.impl.EuclideanDistanceBetweenSolutionAndASolutionListInObjectiveSpace;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.pseudorandom.BoundedRandomGenerator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class SolutionListUtils {
    public static <S extends Solution<?>> List<S> getNonDominatedSolutions(List<S> solutionList) {
        NonDominatedSolutionListArchive nonDominatedSolutionArchive = new NonDominatedSolutionListArchive();
        solutionList.forEach(nonDominatedSolutionArchive::add);
        return nonDominatedSolutionArchive.getSolutionList();
    }

    public <S> S findWorstSolution(Collection<S> solutionList, Comparator<S> comparator) {
        if (solutionList == null || solutionList.isEmpty()) {
            throw new IllegalArgumentException("No solution provided: " + solutionList);
        }
        S worstKnown = solutionList.iterator().next();
        for (S candidateSolution : solutionList) {
            if (comparator.compare(worstKnown, candidateSolution) >= 0) continue;
            worstKnown = candidateSolution;
        }
        return worstKnown;
    }

    public static <S> int findIndexOfBestSolution(List<S> solutionList, Comparator<S> comparator) {
        Check.notNull(solutionList);
        Check.notNull(comparator);
        Check.collectionIsNotEmpty(solutionList);
        int index = 0;
        S bestKnown = solutionList.get(0);
        for (int i = 1; i < solutionList.size(); ++i) {
            S candidateSolution = solutionList.get(i);
            int flag = comparator.compare(bestKnown, candidateSolution);
            if (flag != 1) continue;
            index = i;
            bestKnown = candidateSolution;
        }
        return index;
    }

    public static <S> int findIndexOfWorstSolution(List<? extends S> solutionList, Comparator<S> comparator) {
        Check.notNull(solutionList);
        Check.notNull(comparator);
        Check.collectionIsNotEmpty(solutionList);
        int index = 0;
        S worstKnown = solutionList.get(0);
        for (int i = 1; i < solutionList.size(); ++i) {
            S candidateSolution = solutionList.get(i);
            int flag = comparator.compare(worstKnown, candidateSolution);
            if (flag != -1) continue;
            index = i;
            worstKnown = candidateSolution;
        }
        return index;
    }

    public static <S> S findBestSolution(List<S> solutionList, Comparator<S> comparator) {
        return solutionList.get(SolutionListUtils.findIndexOfBestSolution(solutionList, comparator));
    }

    public static <S extends Solution<?>> double[][] writeObjectivesToMatrix(List<S> solutionList) {
        if (solutionList.size() == 0) {
            return new double[0][0];
        }
        int numberOfObjectives = ((Solution)solutionList.get(0)).objectives().length;
        int solutionListSize = solutionList.size();
        double[][] objectives = new double[solutionListSize][numberOfObjectives];
        for (int i = 0; i < solutionListSize; ++i) {
            for (int j = 0; j < numberOfObjectives; ++j) {
                objectives[i][j] = ((Solution)solutionList.get(i)).objectives()[j];
            }
        }
        return objectives;
    }

    public static <S extends Solution<?>> List<S> normalizeSolutionList(List<S> solutions, double[] minValues, double[] maxValues) {
        ArrayList<Solution> normalizedSolutions = new ArrayList<Solution>(solutions.size());
        for (Solution solution : solutions) {
            normalizedSolutions.add(SolutionUtils.normalize(solution, minValues, maxValues));
        }
        return normalizedSolutions;
    }

    public static <S extends Solution<?>> List<S> normalizeSolutionList(List<S> solutions) {
        Check.notNull(solutions);
        Check.collectionIsNotEmpty(solutions);
        double[] minValues = new double[((Solution)solutions.get(0)).objectives().length];
        double[] maxValues = new double[((Solution)solutions.get(0)).objectives().length];
        for (int i = 0; i < minValues.length; ++i) {
            int best = SolutionListUtils.findIndexOfBestSolution(solutions, new ObjectiveComparator(i));
            int worst = SolutionListUtils.findIndexOfWorstSolution(solutions, new ObjectiveComparator(i));
            minValues[i] = ((Solution)solutions.get(best)).objectives()[i];
            maxValues[i] = ((Solution)solutions.get(worst)).objectives()[i];
        }
        return SolutionListUtils.normalizeSolutionList(solutions, minValues, maxValues);
    }

    public static <S extends Solution<?>> List<S> getInvertedFront(List<S> solutionSet) {
        ArrayList invertedFront = new ArrayList(solutionSet.size());
        int numberOfObjectives = ((Solution)solutionSet.get(0)).objectives().length;
        for (int i = 0; i < solutionSet.size(); ++i) {
            invertedFront.add(i, ((Solution)solutionSet.get(i)).copy());
            for (int j = 0; j < numberOfObjectives; ++j) {
                if (((Solution)solutionSet.get(i)).objectives()[j] <= 1.0 && ((Solution)solutionSet.get(i)).objectives()[j] >= 0.0) {
                    ((Solution)invertedFront.get((int)i)).objectives()[j] = 1.0 - ((Solution)solutionSet.get(i)).objectives()[j];
                    continue;
                }
                if (((Solution)solutionSet.get(i)).objectives()[j] > 1.0) {
                    ((Solution)invertedFront.get((int)i)).objectives()[j] = 0.0;
                    continue;
                }
                if (!(((Solution)solutionSet.get(i)).objectives()[j] < 0.0)) continue;
                ((Solution)invertedFront.get((int)i)).objectives()[j] = 1.0;
            }
        }
        return invertedFront;
    }

    public static <S extends Solution<?>> boolean isSolutionDominatedBySolutionList(S solution, List<? extends S> solutionSet) {
        boolean result = false;
        DominanceComparator dominance = new DominanceComparator();
        for (int i = 0; !result && i < solutionSet.size(); ++i) {
            if (dominance.compare(solution, (Solution)solutionSet.get(i)) != 1) continue;
            result = true;
        }
        return result;
    }

    public static <S> List<S> selectNRandomDifferentSolutions(int numberOfSolutionsToBeReturned, List<S> solutionList) {
        JMetalRandom random = JMetalRandom.getInstance();
        return SolutionListUtils.selectNRandomDifferentSolutions(numberOfSolutionsToBeReturned, solutionList, (low, up) -> random.nextInt((int)low, (int)up));
    }

    public static <S> List<S> selectNRandomDifferentSolutions(int numberOfSolutionsToBeReturned, List<S> solutionList, BoundedRandomGenerator<Integer> randomGenerator) {
        Check.notNull(solutionList);
        Check.collectionIsNotEmpty(solutionList);
        Check.that(solutionList.size() >= numberOfSolutionsToBeReturned, "The solution list size (" + solutionList.size() + ") is less than the number of requested solutions (" + numberOfSolutionsToBeReturned + ")");
        ArrayList<S> resultList = new ArrayList<S>(numberOfSolutionsToBeReturned);
        if (solutionList.size() == 1) {
            resultList.add(solutionList.get(0));
        } else {
            HashSet<Integer> positions = new HashSet<Integer>(numberOfSolutionsToBeReturned);
            while (positions.size() < numberOfSolutionsToBeReturned) {
                int nextPosition = randomGenerator.getRandomValue(0, solutionList.size() - 1);
                if (positions.contains(nextPosition)) continue;
                positions.add(nextPosition);
                resultList.add(solutionList.get(nextPosition));
            }
        }
        return resultList;
    }

    public static <S extends Solution<?>> double[][] distanceMatrix(List<S> solutionSet) {
        double[][] distance = new double[solutionSet.size()][solutionSet.size()];
        for (int i = 0; i < solutionSet.size(); ++i) {
            distance[i][i] = 0.0;
            for (int j = i + 1; j < solutionSet.size(); ++j) {
                distance[i][j] = SolutionUtils.distanceBetweenObjectives((Solution)solutionSet.get(i), (Solution)solutionSet.get(j));
                distance[j][i] = distance[i][j];
            }
        }
        return distance;
    }

    public static <S extends Solution<?>> double[][] normalizedDistanceMatrix(List<S> solutionSet, double[] maxs, double[] mins) {
        double[][] distance = new double[solutionSet.size()][solutionSet.size()];
        for (int i = 0; i < solutionSet.size(); ++i) {
            distance[i][i] = 0.0;
            for (int j = i + 1; j < solutionSet.size(); ++j) {
                distance[i][j] = SolutionUtils.normalizedDistanceBetweenObjectives((Solution)solutionSet.get(i), (Solution)solutionSet.get(j), maxs, mins);
                distance[j][i] = distance[i][j];
            }
        }
        return distance;
    }

    public static <S> boolean solutionListsAreEquals(List<S> solutionList, List<S> newSolutionList) {
        for (int i = 0; i < solutionList.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < newSolutionList.size(); ++j) {
                if (!solutionList.get(i).equals(newSolutionList.get(j))) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static <S> void restart(List<S> solutionList, Problem<S> problem, int percentageOfSolutionsToRemove) {
        Check.notNull(solutionList);
        Check.collectionIsNotEmpty(solutionList);
        Check.that(percentageOfSolutionsToRemove >= 0 && percentageOfSolutionsToRemove <= 100, "The percentage of solutions to remove is invalid: " + percentageOfSolutionsToRemove);
        int solutionListOriginalSize = solutionList.size();
        int numberOfSolutionsToRemove = (int)((double)(solutionListOriginalSize * percentageOfSolutionsToRemove) / 100.0);
        SolutionListUtils.removeSolutionsFromList(solutionList, numberOfSolutionsToRemove);
        SolutionListUtils.fillPopulationWithNewSolutions(solutionList, problem, solutionListOriginalSize);
    }

    public static <S> void removeSolutionsFromList(List<S> solutionList, int numberOfSolutionsToRemove) {
        if (solutionList.size() < numberOfSolutionsToRemove) {
            throw new JMetalException("The list size (" + solutionList.size() + ") is lower than the number of solutions to remove (" + numberOfSolutionsToRemove + ")");
        }
        for (int i = 0; i < numberOfSolutionsToRemove; ++i) {
            solutionList.remove(0);
        }
    }

    public static <S> void fillPopulationWithNewSolutions(List<S> solutionList, Problem<S> problem, int maxListSize) {
        while (solutionList.size() < maxListSize) {
            solutionList.add(problem.createSolution());
        }
    }

    public static <S extends Solution<?>> double[] getObjectiveArrayFromSolutionList(List<S> solutionList, int objective) {
        double[] result = new double[solutionList.size()];
        for (int i = 0; i < solutionList.size(); ++i) {
            result[i] = ((Solution)solutionList.get(i)).objectives()[objective];
        }
        return result;
    }

    public static <S extends Solution<?>> List<S> distanceBasedSubsetSelection(List<S> originalSolutionList, int finalListSize) {
        Check.notNull(originalSolutionList);
        Check.collectionIsNotEmpty(originalSolutionList);
        if (originalSolutionList.size() <= finalListSize) {
            return originalSolutionList;
        }
        if (((Solution)originalSolutionList.get(0)).objectives().length == 2) {
            CrowdingDistanceArchive archive = new CrowdingDistanceArchive(finalListSize);
            originalSolutionList.forEach(archive::add);
            return archive.getSolutionList();
        }
        for (int i = 0; i < originalSolutionList.size(); ++i) {
            ((Solution)originalSolutionList.get(i)).attributes().put("INDEX_", i);
        }
        ArrayList<S> solutions = new ArrayList<S>();
        solutions.addAll(SolutionListUtils.normalizeSolutionList(originalSolutionList));
        int randomObjective = JMetalRandom.getInstance().nextInt(0, ((Solution)solutions.get(0)).objectives().length - 1);
        int bestSolutionIndex = SolutionListUtils.findIndexOfBestSolution(solutions, new ObjectiveComparator(randomObjective));
        ArrayList<Solution> selectedSolutions = new ArrayList<Solution>(finalListSize);
        selectedSolutions.add((Solution)solutions.get(bestSolutionIndex));
        solutions.remove(bestSolutionIndex);
        EuclideanDistanceBetweenSolutionAndASolutionListInObjectiveSpace distance = new EuclideanDistanceBetweenSolutionAndASolutionListInObjectiveSpace();
        while (selectedSolutions.size() < finalListSize) {
            for (Solution solution : solutions) {
                solution.attributes().put("SUBSET_SELECTION_DISTANCE", distance.compute(solution, selectedSolutions));
            }
            int largestDistanceSolutionIndex = SolutionListUtils.findIndexOfBestSolution(solutions, new DoubleValueAttributeComparator("SUBSET_SELECTION_DISTANCE", AttributeComparator.Ordering.DESCENDING));
            selectedSolutions.add((Solution)solutions.get(largestDistanceSolutionIndex));
            solutions.remove(largestDistanceSolutionIndex);
        }
        ArrayList<Solution> resultList = new ArrayList<Solution>();
        for (Solution solution : selectedSolutions) {
            resultList.add((Solution)originalSolutionList.get((Integer)solution.attributes().get("INDEX_")));
        }
        return resultList;
    }

    public static <S extends Solution<?>> double[][] getMatrixWithObjectiveValues(List<S> solutionList) {
        double[][] matrix = new double[solutionList.size()][];
        IntStream.range(0, solutionList.size()).forEach(i -> {
            matrix[i] = ((Solution)solutionList.get(i)).objectives();
        });
        return matrix;
    }
}

