/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.Comparator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.impl.AbstractBoundedArchive;
import org.uma.jmetal.util.densityestimator.DensityEstimator;
import org.uma.jmetal.util.densityestimator.impl.CrowdingDistanceDensityEstimator;

public class CrowdingDistanceArchive<S extends Solution<?>>
extends AbstractBoundedArchive<S> {
    private Comparator<S> crowdingDistanceComparator;
    private DensityEstimator<S> crowdingDistance = new CrowdingDistanceDensityEstimator();

    public CrowdingDistanceArchive(int maxSize) {
        super(maxSize);
        this.crowdingDistanceComparator = Comparator.comparing(this.crowdingDistance::getValue).reversed();
    }

    @Override
    public void prune() {
        if (this.getSolutionList().size() > this.getMaxSize()) {
            this.computeDensityEstimator();
            Solution worst = (Solution)new SolutionListUtils().findWorstSolution(this.getSolutionList(), this.crowdingDistanceComparator);
            this.getSolutionList().remove(worst);
        }
    }

    @Override
    public Comparator<S> getComparator() {
        return this.crowdingDistanceComparator;
    }

    @Override
    public void computeDensityEstimator() {
        this.crowdingDistance.compute(this.getSolutionList());
    }
}

