/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.archive.Archive;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.comparator.EqualSolutionsComparator;

public class NonDominatedSolutionListArchive<S extends Solution<?>>
implements Archive<S> {
    private List<S> solutionList;
    private Comparator<S> dominanceComparator;
    private Comparator<S> equalSolutions = new EqualSolutionsComparator();

    public NonDominatedSolutionListArchive() {
        this(new DominanceComparator());
    }

    public NonDominatedSolutionListArchive(DominanceComparator<S> comparator) {
        this.dominanceComparator = comparator;
        this.solutionList = new ArrayList<S>();
    }

    @Override
    public boolean add(S solution) {
        boolean solutionInserted = false;
        if (this.solutionList.size() != 0) {
            Iterator<S> iterator = this.solutionList.iterator();
            boolean isDominated = false;
            boolean isContained = false;
            while (!isDominated && !isContained && iterator.hasNext()) {
                int equalflag;
                Solution listIndividual = (Solution)iterator.next();
                int flag = this.dominanceComparator.compare(solution, listIndividual);
                if (flag == -1) {
                    iterator.remove();
                    continue;
                }
                if (flag == 1) {
                    isDominated = true;
                    continue;
                }
                if (flag != 0 || (equalflag = this.equalSolutions.compare(solution, listIndividual)) != 0) continue;
                isContained = true;
            }
            if (!isDominated && !isContained) {
                this.solutionList.add(solution);
                solutionInserted = true;
            }
            return solutionInserted;
        }
        this.solutionList.add(solution);
        solutionInserted = true;
        return solutionInserted;
    }

    public Archive<S> join(Archive<S> archive) {
        return this.addAll(archive.getSolutionList());
    }

    public Archive<S> addAll(List<S> list) {
        for (Solution solution : list) {
            this.add((S)solution);
        }
        return this;
    }

    @Override
    public List<S> getSolutionList() {
        return this.solutionList;
    }

    @Override
    public int size() {
        return this.solutionList.size();
    }

    @Override
    public S get(int index) {
        return (S)((Solution)this.solutionList.get(index));
    }
}

