/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.Comparator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.impl.AbstractBoundedArchive;
import org.uma.jmetal.util.comparator.SpatialSpreadDeviationComparator;
import org.uma.jmetal.util.solutionattribute.DensityEstimator;
import org.uma.jmetal.util.solutionattribute.impl.SpatialSpreadDeviation;

public class SpatialSpreadDeviationArchive<S extends Solution<?>>
extends AbstractBoundedArchive<S> {
    private Comparator<S> crowdingDistanceComparator = new SpatialSpreadDeviationComparator();
    private DensityEstimator<S> crowdingDistance = new SpatialSpreadDeviation();

    public SpatialSpreadDeviationArchive(int maxSize) {
        super(maxSize);
    }

    @Override
    public void prune() {
        if (this.getSolutionList().size() > this.getMaxSize()) {
            this.computeDensityEstimator();
            Solution worst = (Solution)new SolutionListUtils().findWorstSolution(this.getSolutionList(), this.crowdingDistanceComparator);
            this.getSolutionList().remove(worst);
        }
    }

    @Override
    public Comparator<S> getComparator() {
        return this.crowdingDistanceComparator;
    }

    @Override
    public void computeDensityEstimator() {
        this.crowdingDistance.computeDensityEstimator(this.getSolutionList());
    }
}

