/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archivewithreferencepoint;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.archive.impl.AbstractBoundedArchive;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public abstract class ArchiveWithReferencePoint<S extends Solution<?>>
extends AbstractBoundedArchive<S> {
    protected List<Double> referencePoint;
    protected S referencePointSolution;
    protected Comparator<S> comparator;

    public ArchiveWithReferencePoint(int maxSize, List<Double> referencePoint, Comparator<S> comparator) {
        super(maxSize);
        this.referencePoint = referencePoint;
        this.comparator = comparator;
        this.referencePointSolution = null;
    }

    @Override
    public synchronized boolean add(S solution) {
        boolean result;
        if (this.referencePointSolution == null) {
            Solution copy = solution.copy();
            this.referencePointSolution = copy;
            for (int i = 0; i < solution.objectives().length; ++i) {
                this.referencePointSolution.objectives()[i] = this.referencePoint.get(i);
            }
        }
        Object dominatedSolution = null;
        if (this.dominanceTest(solution, this.referencePointSolution) == 0) {
            if (this.getSolutionList().size() == 0) {
                result = true;
            } else if (JMetalRandom.getInstance().nextDouble() < 0.05) {
                result = true;
                dominatedSolution = solution;
            } else {
                result = false;
            }
        } else {
            result = true;
        }
        if (result) {
            result = super.add(solution);
        }
        if (result && dominatedSolution != null && this.getSolutionList().size() > 1) {
            this.getSolutionList().remove(dominatedSolution);
        }
        return result;
    }

    @Override
    public synchronized void prune() {
        if (this.getSolutionList().size() > this.getMaxSize()) {
            this.computeDensityEstimator();
            Solution worst = (Solution)new SolutionListUtils().findWorstSolution(this.getSolutionList(), this.comparator);
            this.getSolutionList().remove(worst);
        }
    }

    public synchronized void changeReferencePoint(List<Double> newReferencePoint) {
        int i;
        this.referencePoint = newReferencePoint;
        for (i = 0; i < this.referencePoint.size(); ++i) {
            this.referencePointSolution.objectives()[i] = this.referencePoint.get(i);
        }
        i = 0;
        while (i < this.getSolutionList().size()) {
            if (this.dominanceTest((Solution)this.getSolutionList().get(i), this.referencePointSolution) == 0) {
                this.getSolutionList().remove(i);
                continue;
            }
            ++i;
        }
        this.referencePointSolution = null;
    }

    private int dominanceTest(S solution1, S solution2) {
        boolean bestIsOne = false;
        boolean bestIsTwo = false;
        for (int i = 0; i < solution1.objectives().length; ++i) {
            double value2;
            double value1 = solution1.objectives()[i];
            if (value1 == (value2 = solution2.objectives()[i])) continue;
            if (value1 < value2) {
                bestIsOne = true;
            }
            if (!(value2 < value1)) continue;
            bestIsTwo = true;
        }
        int result = bestIsOne > bestIsTwo ? -1 : (bestIsTwo > bestIsOne ? 1 : 0);
        return result;
    }
}

