/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.ConstraintViolationComparator;
import org.uma.jmetal.util.errorchecking.Check;

public class DominanceComparator<S extends Solution<?>>
implements Comparator<S>,
Serializable {
    private ConstraintViolationComparator<S> constraintViolationComparator;

    public DominanceComparator() {
        this(new ConstraintViolationComparator());
    }

    public DominanceComparator(ConstraintViolationComparator<S> constraintComparator) {
        this.constraintViolationComparator = constraintComparator;
    }

    @Override
    public int compare(S solution1, S solution2) {
        Check.notNull(solution1);
        Check.notNull(solution2);
        Check.that(solution1.objectives().length == solution2.objectives().length, "Cannot compare because solution1 has " + solution1.objectives().length + " objectives and solution2 has " + solution2.objectives().length);
        int result = this.constraintViolationComparator.compare(solution1, solution2);
        if (result == 0) {
            result = this.dominanceTest(solution1, solution2);
        }
        return result;
    }

    private int dominanceTest(S solution1, S solution2) {
        int bestIsOne = 0;
        int bestIsTwo = 0;
        for (int i = 0; i < solution1.objectives().length; ++i) {
            double value2;
            double value1 = solution1.objectives()[i];
            if (value1 == (value2 = solution2.objectives()[i])) continue;
            if (value1 < value2) {
                bestIsOne = 1;
            }
            if (!(value2 < value1)) continue;
            bestIsTwo = 1;
        }
        int result = Integer.compare(bestIsTwo, bestIsOne);
        return result;
    }
}

