/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.comparator;

import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.ConstraintViolationComparator;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.errorchecking.Check;

public class EpsilonDominanceComparator<S extends Solution<?>>
extends DominanceComparator<S> {
    private ConstraintViolationComparator<S> constraintViolationComparator;
    private double epsilon = 0.0;

    public EpsilonDominanceComparator() {
        this(new ConstraintViolationComparator(), 0.0);
    }

    public EpsilonDominanceComparator(double epsilon) {
        this(new ConstraintViolationComparator(), epsilon);
    }

    public EpsilonDominanceComparator(ConstraintViolationComparator<S> constraintComparator) {
        this(constraintComparator, 0.0);
    }

    public EpsilonDominanceComparator(ConstraintViolationComparator<S> constraintComparator, double epsilon) {
        this.constraintViolationComparator = constraintComparator;
        this.epsilon = epsilon;
    }

    @Override
    public int compare(S solution1, S solution2) {
        Check.notNull(solution1);
        Check.notNull(solution2);
        Check.that(solution1.objectives().length == solution2.objectives().length, "Cannot compare because solution1 has " + solution1.objectives().length + " objectives and solution2 has " + solution2.objectives().length);
        int result = this.constraintViolationComparator.compare(solution1, solution2);
        if (result == 0) {
            result = this.dominanceTest((Solution<?>)solution1, (Solution<?>)solution2);
        }
        return result;
    }

    private int dominanceTest(Solution<?> solution1, Solution<?> solution2) {
        boolean bestIsOne = false;
        boolean bestIsTwo = false;
        for (int i = 0; i < solution1.objectives().length; ++i) {
            double value2;
            double value1 = Math.floor(solution1.objectives()[i] / this.epsilon);
            if (value1 < (value2 = Math.floor(solution2.objectives()[i] / this.epsilon))) {
                bestIsOne = true;
                if (!bestIsTwo) continue;
                return 0;
            }
            if (!(value2 < value1)) continue;
            bestIsTwo = true;
            if (!bestIsOne) continue;
            return 0;
        }
        if (!bestIsOne && !bestIsTwo) {
            double dist1 = 0.0;
            double dist2 = 0.0;
            for (int i = 0; i < solution1.objectives().length; ++i) {
                double index1 = Math.floor(solution1.objectives()[i] / this.epsilon);
                double index2 = Math.floor(solution2.objectives()[i] / this.epsilon);
                dist1 += Math.pow(solution1.objectives()[i] - index1 * this.epsilon, 2.0);
                dist2 += Math.pow(solution2.objectives()[i] - index2 * this.epsilon, 2.0);
            }
            if (dist1 < dist2) {
                return -1;
            }
            return 1;
        }
        if (bestIsTwo) {
            return 1;
        }
        return -1;
    }
}

