/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.comparator;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.DominanceComparator;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class GDominanceComparator<S extends Solution<?>>
implements Comparator<S>,
Serializable {
    private List<Double> referencePoint;
    private DominanceComparator<S> dominanceComparator;

    public GDominanceComparator(List<Double> referencePoint) {
        this.referencePoint = referencePoint;
        this.dominanceComparator = new DominanceComparator();
    }

    @Override
    public int compare(S solution1, S solution2) {
        if (solution1 == null) {
            throw new JMetalException("Solution1 is null");
        }
        if (solution2 == null) {
            throw new JMetalException("Solution2 is null");
        }
        if (solution1.objectives().length != solution2.objectives().length) {
            throw new JMetalException("Cannot compare because solution1 has " + solution1.objectives().length + " objectives and solution2 has " + solution2.objectives().length);
        }
        int result = this.flagComparison(solution1, solution2);
        return result;
    }

    private int flagComparison(S solution1, S solution2) {
        int result = this.flag(solution1) > this.flag(solution2) ? -1 : (this.flag(solution1) < this.flag(solution2) ? 1 : this.dominanceComparator.compare(solution1, solution2));
        return result;
    }

    private int flag(S solution) {
        int i;
        int result = 1;
        for (i = 0; i < solution.objectives().length; ++i) {
            if (!(solution.objectives()[i] > this.referencePoint.get(i))) continue;
            result = 0;
        }
        if (result == 0) {
            result = 1;
            for (i = 0; i < solution.objectives().length; ++i) {
                if (!(solution.objectives()[i] < this.referencePoint.get(i))) continue;
                result = 0;
            }
        }
        return result;
    }
}

