/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.legacy.front.util;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.util.distance.Distance;
import org.uma.jmetal.util.distance.impl.EuclideanDistanceBetweenVectors;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.legacy.front.Front;
import org.uma.jmetal.util.legacy.front.impl.ArrayFront;
import org.uma.jmetal.util.point.Point;
import org.uma.jmetal.util.point.PointSolution;

@Deprecated
public class FrontUtils {
    public static double[] getMaximumValues(Front front) {
        int i;
        if (front == null) {
            throw new NullFrontException();
        }
        if (front.getNumberOfPoints() == 0) {
            throw new EmptyFrontException();
        }
        int numberOfObjectives = front.getPoint(0).getDimension();
        double[] maximumValue = new double[numberOfObjectives];
        for (i = 0; i < numberOfObjectives; ++i) {
            maximumValue[i] = Double.NEGATIVE_INFINITY;
        }
        for (i = 0; i < front.getNumberOfPoints(); ++i) {
            for (int j = 0; j < numberOfObjectives; ++j) {
                if (!(front.getPoint(i).getValue(j) > maximumValue[j])) continue;
                maximumValue[j] = front.getPoint(i).getValue(j);
            }
        }
        return maximumValue;
    }

    public static double[] getMinimumValues(Front front) {
        int i;
        if (front == null) {
            throw new NullFrontException();
        }
        if (front.getNumberOfPoints() == 0) {
            throw new EmptyFrontException();
        }
        int numberOfObjectives = front.getPoint(0).getDimension();
        double[] minimumValue = new double[numberOfObjectives];
        for (i = 0; i < numberOfObjectives; ++i) {
            minimumValue[i] = Double.MAX_VALUE;
        }
        for (i = 0; i < front.getNumberOfPoints(); ++i) {
            for (int j = 0; j < numberOfObjectives; ++j) {
                if (!(front.getPoint(i).getValue(j) < minimumValue[j])) continue;
                minimumValue[j] = front.getPoint(i).getValue(j);
            }
        }
        return minimumValue;
    }

    public static double distanceToNearestPoint(Point point, Front front) {
        return FrontUtils.distanceToNearestPoint(point, front, new EuclideanDistanceBetweenVectors());
    }

    public static double distanceToNearestPoint(Point point, Front front, Distance<double[], double[]> distance) {
        if (front == null) {
            throw new NullFrontException();
        }
        if (front.getNumberOfPoints() == 0) {
            throw new EmptyFrontException();
        }
        if (point == null) {
            throw new JMetalException("The point is null");
        }
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            double aux = distance.compute(point.getValues(), front.getPoint(i).getValues());
            if (!(aux < minDistance) || !(aux > 0.0)) continue;
            minDistance = aux;
        }
        return minDistance;
    }

    public static double distanceToClosestPoint(Point point, Front front) {
        return FrontUtils.distanceToClosestPoint(point, front, new EuclideanDistanceBetweenVectors());
    }

    public static double distanceToClosestPoint(Point point, Front front, Distance<double[], double[]> distance) {
        if (front == null) {
            throw new NullFrontException();
        }
        if (front.getNumberOfPoints() == 0) {
            throw new EmptyFrontException();
        }
        if (point == null) {
            throw new JMetalException("The point is null");
        }
        double minDistance = distance.compute(point.getValues(), front.getPoint(0).getValues());
        for (int i = 1; i < front.getNumberOfPoints(); ++i) {
            double aux = distance.compute(point.getValues(), front.getPoint(i).getValues());
            if (!(aux < minDistance)) continue;
            minDistance = aux;
        }
        return minDistance;
    }

    public static Front getInvertedFront(Front front) {
        if (front == null) {
            throw new NullFrontException();
        }
        if (front.getNumberOfPoints() == 0) {
            throw new EmptyFrontException();
        }
        int numberOfDimensions = front.getPoint(0).getDimension();
        ArrayFront invertedFront = new ArrayFront(front.getNumberOfPoints(), numberOfDimensions);
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            for (int j = 0; j < numberOfDimensions; ++j) {
                if (front.getPoint(i).getValue(j) <= 1.0 && front.getPoint(i).getValue(j) >= 0.0) {
                    invertedFront.getPoint(i).setValue(j, 1.0 - front.getPoint(i).getValue(j));
                    continue;
                }
                if (front.getPoint(i).getValue(j) > 1.0) {
                    invertedFront.getPoint(i).setValue(j, 0.0);
                    continue;
                }
                if (!(front.getPoint(i).getValue(j) < 0.0)) continue;
                invertedFront.getPoint(i).setValue(j, 1.0);
            }
        }
        return invertedFront;
    }

    public static double[][] convertFrontToArray(Front front) {
        if (front == null) {
            throw new NullFrontException();
        }
        double[][] arrayFront = new double[front.getNumberOfPoints()][];
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            arrayFront[i] = new double[front.getPoint(i).getDimension()];
            for (int j = 0; j < front.getPoint(i).getDimension(); ++j) {
                arrayFront[i][j] = front.getPoint(i).getValue(j);
            }
        }
        return arrayFront;
    }

    public static List<PointSolution> convertFrontToSolutionList(Front front) {
        if (front == null) {
            throw new NullFrontException();
        }
        int solutionSetSize = front.getNumberOfPoints();
        int numberOfObjectives = front.getNumberOfPoints() == 0 ? 0 : front.getPoint(0).getDimension();
        ArrayList<PointSolution> solutionSet = new ArrayList<PointSolution>(solutionSetSize);
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            PointSolution solution = new PointSolution(numberOfObjectives);
            for (int j = 0; j < numberOfObjectives; ++j) {
                solution.objectives()[j] = front.getPoint(i).getValue(j);
            }
            solutionSet.add(solution);
        }
        return solutionSet;
    }

    private static class NullFrontException
    extends JMetalException {
        public NullFrontException() {
            super("The front is null");
        }
    }

    private static class EmptyFrontException
    extends JMetalException {
        public EmptyFrontException() {
            super("The front is empty");
        }
    }
}

