/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.legacy.qualityindicator.impl.hypervolume.impl;

import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.HypervolumeContributionComparator;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.legacy.front.impl.ArrayFront;
import org.uma.jmetal.util.legacy.front.util.FrontNormalizer;
import org.uma.jmetal.util.legacy.front.util.FrontUtils;
import org.uma.jmetal.util.legacy.qualityindicator.impl.hypervolume.Hypervolume;
import org.uma.jmetal.util.solutionattribute.impl.HypervolumeContributionAttribute;

@Deprecated
public class WFGHypervolume<S extends Solution<?>>
extends Hypervolume<S> {
    private static final double DEFAULT_OFFSET = 100.0;
    private double offset = 100.0;
    static int n;
    static Front[] fs;
    static int safe;
    static int fr;

    public WFGHypervolume() {
    }

    public WFGHypervolume(double[] referencePoint) {
        super(referencePoint);
    }

    public WFGHypervolume(String referenceParetoFrontFile) throws FileNotFoundException {
        super(referenceParetoFrontFile);
    }

    public WFGHypervolume(org.uma.jmetal.util.legacy.front.Front referenceParetoFront) {
        super(referenceParetoFront);
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(double offset) {
        this.offset = offset;
    }

    @Override
    public Double evaluate(List<S> paretoFrontApproximation) {
        Check.notNull(paretoFrontApproximation);
        return this.hypervolume(new ArrayFront(paretoFrontApproximation), this.referenceParetoFront);
    }

    static double CalculateHypervolume(double[][] fronton, int noPoints, int noObjectives) {
        n = noObjectives;
        safe = 0;
        fr = 0;
        Front frente = new Front(fronton);
        fs = new Front[noObjectives - 2];
        for (int x = 0; x < noObjectives - 2; ++x) {
            WFGHypervolume.fs[x] = new Front(fronton);
        }
        double volume = WFGHypervolume.hv(frente);
        return volume;
    }

    static boolean BEATS(double x, double y) {
        return x > y;
    }

    static double WORSE(double x, double y) {
        return x > y ? y : x;
    }

    static int dominates2way(Point p, Point q, int k) {
        for (int i = k; i >= 0; --i) {
            if (WFGHypervolume.BEATS(p.objectives[i], q.objectives[i])) {
                for (int j = i - 1; j >= 0; --j) {
                    if (!WFGHypervolume.BEATS(q.objectives[j], p.objectives[j])) continue;
                    return 0;
                }
                return -1;
            }
            if (!WFGHypervolume.BEATS(q.objectives[i], p.objectives[i])) continue;
            for (int j = i - 1; j >= 0; --j) {
                if (!WFGHypervolume.BEATS(p.objectives[j], q.objectives[j])) continue;
                return 0;
            }
            return 1;
        }
        return 2;
    }

    static boolean dominates1way(Point p, Point q, int k) {
        for (int i = k; i >= 0; --i) {
            if (!WFGHypervolume.BEATS(q.objectives[i], p.objectives[i])) continue;
            return false;
        }
        return true;
    }

    static void makeDominatedBit(Front ps, int p) {
        int k;
        int j;
        int i;
        int l = 0;
        int u = p - 1;
        for (int i2 = p - 1; i2 >= 0; --i2) {
            int j2;
            if (WFGHypervolume.BEATS(ps.points[p].objectives[n - 1], ps.points[i2].objectives[n - 1])) {
                WFGHypervolume.fs[WFGHypervolume.fr].points[u].objectives[WFGHypervolume.n - 1] = ps.points[i2].objectives[n - 1];
                for (j2 = 0; j2 < n - 1; ++j2) {
                    WFGHypervolume.fs[WFGHypervolume.fr].points[u].objectives[j2] = WFGHypervolume.WORSE(ps.points[p].objectives[j2], ps.points[i2].objectives[j2]);
                }
                --u;
                continue;
            }
            WFGHypervolume.fs[WFGHypervolume.fr].points[l].objectives[WFGHypervolume.n - 1] = ps.points[p].objectives[n - 1];
            for (j2 = 0; j2 < n - 1; ++j2) {
                WFGHypervolume.fs[WFGHypervolume.fr].points[l].objectives[j2] = WFGHypervolume.WORSE(ps.points[p].objectives[j2], ps.points[i2].objectives[j2]);
            }
            ++l;
        }
        WFGHypervolume.fs[WFGHypervolume.fr].nPoints = 1;
        for (i = 1; i < l; ++i) {
            j = 0;
            block12: while (j < WFGHypervolume.fs[WFGHypervolume.fr].nPoints) {
                switch (WFGHypervolume.dominates2way(WFGHypervolume.fs[WFGHypervolume.fr].points[i], WFGHypervolume.fs[WFGHypervolume.fr].points[j], n - 2)) {
                    case 0: {
                        ++j;
                        continue block12;
                    }
                    case -1: {
                        Point t = WFGHypervolume.fs[WFGHypervolume.fr].points[j];
                        WFGHypervolume.fs[WFGHypervolume.fr].points[j] = WFGHypervolume.fs[WFGHypervolume.fr].points[i];
                        WFGHypervolume.fs[WFGHypervolume.fr].points[i] = t;
                        while (j < WFGHypervolume.fs[WFGHypervolume.fr].nPoints - 1 && WFGHypervolume.dominates1way(WFGHypervolume.fs[WFGHypervolume.fr].points[j], WFGHypervolume.fs[WFGHypervolume.fr].points[WFGHypervolume.fs[WFGHypervolume.fr].nPoints - 1], n - 1)) {
                            --WFGHypervolume.fs[WFGHypervolume.fr].nPoints;
                        }
                        k = j + 1;
                        while (k < WFGHypervolume.fs[WFGHypervolume.fr].nPoints) {
                            if (WFGHypervolume.dominates1way(WFGHypervolume.fs[WFGHypervolume.fr].points[j], WFGHypervolume.fs[WFGHypervolume.fr].points[k], n - 2)) {
                                t = WFGHypervolume.fs[WFGHypervolume.fr].points[k];
                                --WFGHypervolume.fs[WFGHypervolume.fr].nPoints;
                                WFGHypervolume.fs[WFGHypervolume.fr].points[k] = WFGHypervolume.fs[WFGHypervolume.fr].points[WFGHypervolume.fs[WFGHypervolume.fr].nPoints];
                                WFGHypervolume.fs[WFGHypervolume.fr].points[WFGHypervolume.fs[WFGHypervolume.fr].nPoints] = t;
                                continue;
                            }
                            ++k;
                        }
                        break;
                    }
                }
                j = WFGHypervolume.fs[WFGHypervolume.fr].nPoints + 1;
            }
            if (j != WFGHypervolume.fs[WFGHypervolume.fr].nPoints) continue;
            Point t = WFGHypervolume.fs[WFGHypervolume.fr].points[WFGHypervolume.fs[WFGHypervolume.fr].nPoints];
            WFGHypervolume.fs[WFGHypervolume.fr].points[WFGHypervolume.fs[WFGHypervolume.fr].nPoints] = WFGHypervolume.fs[WFGHypervolume.fr].points[i];
            WFGHypervolume.fs[WFGHypervolume.fr].points[i] = t;
            ++WFGHypervolume.fs[WFGHypervolume.fr].nPoints;
        }
        safe = (int)WFGHypervolume.WORSE(l, WFGHypervolume.fs[WFGHypervolume.fr].nPoints);
        for (i = l; i < p; ++i) {
            j = 0;
            while (j < safe) {
                if (WFGHypervolume.dominates1way(WFGHypervolume.fs[WFGHypervolume.fr].points[j], WFGHypervolume.fs[WFGHypervolume.fr].points[i], n - 2)) {
                    j = WFGHypervolume.fs[WFGHypervolume.fr].nPoints + 1;
                    continue;
                }
                ++j;
            }
            block17: while (j < WFGHypervolume.fs[WFGHypervolume.fr].nPoints) {
                switch (WFGHypervolume.dominates2way(WFGHypervolume.fs[WFGHypervolume.fr].points[i], WFGHypervolume.fs[WFGHypervolume.fr].points[j], n - 1)) {
                    case 0: {
                        ++j;
                        continue block17;
                    }
                    case -1: {
                        Point t = WFGHypervolume.fs[WFGHypervolume.fr].points[j];
                        WFGHypervolume.fs[WFGHypervolume.fr].points[j] = WFGHypervolume.fs[WFGHypervolume.fr].points[i];
                        WFGHypervolume.fs[WFGHypervolume.fr].points[i] = t;
                        while (j < WFGHypervolume.fs[WFGHypervolume.fr].nPoints - 1 && WFGHypervolume.dominates1way(WFGHypervolume.fs[WFGHypervolume.fr].points[j], WFGHypervolume.fs[WFGHypervolume.fr].points[WFGHypervolume.fs[WFGHypervolume.fr].nPoints - 1], n - 1)) {
                            --WFGHypervolume.fs[WFGHypervolume.fr].nPoints;
                        }
                        k = j + 1;
                        while (k < WFGHypervolume.fs[WFGHypervolume.fr].nPoints) {
                            if (WFGHypervolume.dominates1way(WFGHypervolume.fs[WFGHypervolume.fr].points[j], WFGHypervolume.fs[WFGHypervolume.fr].points[k], n - 1)) {
                                t = WFGHypervolume.fs[WFGHypervolume.fr].points[k];
                                --WFGHypervolume.fs[WFGHypervolume.fr].nPoints;
                                WFGHypervolume.fs[WFGHypervolume.fr].points[k] = WFGHypervolume.fs[WFGHypervolume.fr].points[WFGHypervolume.fs[WFGHypervolume.fr].nPoints];
                                WFGHypervolume.fs[WFGHypervolume.fr].points[WFGHypervolume.fs[WFGHypervolume.fr].nPoints] = t;
                                continue;
                            }
                            ++k;
                        }
                        break;
                    }
                }
                j = WFGHypervolume.fs[WFGHypervolume.fr].nPoints + 1;
            }
            if (j != WFGHypervolume.fs[WFGHypervolume.fr].nPoints) continue;
            Point t = WFGHypervolume.fs[WFGHypervolume.fr].points[WFGHypervolume.fs[WFGHypervolume.fr].nPoints];
            WFGHypervolume.fs[WFGHypervolume.fr].points[WFGHypervolume.fs[WFGHypervolume.fr].nPoints] = WFGHypervolume.fs[WFGHypervolume.fr].points[i];
            WFGHypervolume.fs[WFGHypervolume.fr].points[i] = t;
            ++WFGHypervolume.fs[WFGHypervolume.fr].nPoints;
        }
        ++fr;
    }

    static double hv2(Front ps, int k) {
        double volume = ps.points[0].objectives[0] * ps.points[0].objectives[1];
        for (int i = 1; i < k; ++i) {
            volume += ps.points[i].objectives[1] * (ps.points[i].objectives[0] - ps.points[i - 1].objectives[0]);
        }
        return volume;
    }

    static double inclhv(Point p) {
        double volume = 1.0;
        for (int i = 0; i < n; ++i) {
            volume *= p.objectives[i];
        }
        return volume;
    }

    static double inclhv2(Point p, Point q) {
        double vp = 1.0;
        double vq = 1.0;
        double vpq = 1.0;
        for (int i = 0; i < n; ++i) {
            vp *= p.objectives[i];
            vq *= q.objectives[i];
            vpq *= WFGHypervolume.WORSE(p.objectives[i], q.objectives[i]);
        }
        double suma = vp + vq - vpq;
        return suma;
    }

    static double inclhv3(Point p, Point q, Point r) {
        double vp = 1.0;
        double vq = 1.0;
        double vr = 1.0;
        double vpq = 1.0;
        double vpr = 1.0;
        double vqr = 1.0;
        double vpqr = 1.0;
        for (int i = 0; i < n; ++i) {
            vp *= p.objectives[i];
            vq *= q.objectives[i];
            vr *= r.objectives[i];
            if (WFGHypervolume.BEATS(p.objectives[i], q.objectives[i])) {
                if (WFGHypervolume.BEATS(q.objectives[i], r.objectives[i])) {
                    vpq *= q.objectives[i];
                    vpr *= r.objectives[i];
                    vqr *= r.objectives[i];
                    vpqr *= r.objectives[i];
                    continue;
                }
                vpq *= q.objectives[i];
                vpr *= WFGHypervolume.WORSE(p.objectives[i], r.objectives[i]);
                vqr *= q.objectives[i];
                vpqr *= q.objectives[i];
                continue;
            }
            if (WFGHypervolume.BEATS(p.objectives[i], r.objectives[i])) {
                vpq *= p.objectives[i];
                vpr *= r.objectives[i];
                vqr *= r.objectives[i];
                vpqr *= r.objectives[i];
                continue;
            }
            vpq *= p.objectives[i];
            vpr *= p.objectives[i];
            vqr *= WFGHypervolume.WORSE(q.objectives[i], r.objectives[i]);
            vpqr *= p.objectives[i];
        }
        return vp + vq + vr - vpq - vpr - vqr + vpqr;
    }

    static double inclhv4(Point p, Point q, Point r, Point s) {
        double vp = 1.0;
        double vq = 1.0;
        double vr = 1.0;
        double vs = 1.0;
        double vpq = 1.0;
        double vpr = 1.0;
        double vps = 1.0;
        double vqr = 1.0;
        double vqs = 1.0;
        double vrs = 1.0;
        double vpqr = 1.0;
        double vpqs = 1.0;
        double vprs = 1.0;
        double vqrs = 1.0;
        double vpqrs = 1.0;
        for (int i = 0; i < n; ++i) {
            double z1;
            vp *= p.objectives[i];
            vq *= q.objectives[i];
            vr *= r.objectives[i];
            vs *= s.objectives[i];
            if (WFGHypervolume.BEATS(p.objectives[i], q.objectives[i])) {
                if (WFGHypervolume.BEATS(q.objectives[i], r.objectives[i])) {
                    if (WFGHypervolume.BEATS(r.objectives[i], s.objectives[i])) {
                        vpq *= q.objectives[i];
                        vpr *= r.objectives[i];
                        vps *= s.objectives[i];
                        vqr *= r.objectives[i];
                        vqs *= s.objectives[i];
                        vrs *= s.objectives[i];
                        vpqr *= r.objectives[i];
                        vpqs *= s.objectives[i];
                        vprs *= s.objectives[i];
                        vqrs *= s.objectives[i];
                        vpqrs *= s.objectives[i];
                        continue;
                    }
                    z1 = WFGHypervolume.WORSE(q.objectives[i], s.objectives[i]);
                    vpq *= q.objectives[i];
                    vpr *= r.objectives[i];
                    vps *= WFGHypervolume.WORSE(p.objectives[i], s.objectives[i]);
                    vqr *= r.objectives[i];
                    vqs *= z1;
                    vrs *= r.objectives[i];
                    vpqr *= r.objectives[i];
                    vpqs *= z1;
                    vprs *= r.objectives[i];
                    vqrs *= r.objectives[i];
                    vpqrs *= r.objectives[i];
                    continue;
                }
                if (WFGHypervolume.BEATS(q.objectives[i], s.objectives[i])) {
                    vpq *= q.objectives[i];
                    vpr *= WFGHypervolume.WORSE(p.objectives[i], r.objectives[i]);
                    vps *= s.objectives[i];
                    vqr *= q.objectives[i];
                    vqs *= s.objectives[i];
                    vrs *= s.objectives[i];
                    vpqr *= q.objectives[i];
                    vpqs *= s.objectives[i];
                    vprs *= s.objectives[i];
                    vqrs *= s.objectives[i];
                    vpqrs *= s.objectives[i];
                    continue;
                }
                z1 = WFGHypervolume.WORSE(p.objectives[i], r.objectives[i]);
                vpq *= q.objectives[i];
                vpr *= z1;
                vps *= WFGHypervolume.WORSE(p.objectives[i], s.objectives[i]);
                vqr *= q.objectives[i];
                vqs *= q.objectives[i];
                vrs *= WFGHypervolume.WORSE(r.objectives[i], s.objectives[i]);
                vpqr *= q.objectives[i];
                vpqs *= q.objectives[i];
                vprs *= WFGHypervolume.WORSE(z1, s.objectives[i]);
                vqrs *= q.objectives[i];
                vpqrs *= q.objectives[i];
                continue;
            }
            if (WFGHypervolume.BEATS(q.objectives[i], r.objectives[i])) {
                double z2;
                if (WFGHypervolume.BEATS(p.objectives[i], s.objectives[i])) {
                    z1 = WFGHypervolume.WORSE(p.objectives[i], r.objectives[i]);
                    z2 = WFGHypervolume.WORSE(r.objectives[i], s.objectives[i]);
                    vpq *= p.objectives[i];
                    vpr *= z1;
                    vps *= s.objectives[i];
                    vqr *= r.objectives[i];
                    vqs *= s.objectives[i];
                    vrs *= z2;
                    vpqr *= z1;
                    vpqs *= s.objectives[i];
                    vprs *= z2;
                    vqrs *= z2;
                    vpqrs *= z2;
                    continue;
                }
                z1 = WFGHypervolume.WORSE(p.objectives[i], r.objectives[i]);
                z2 = WFGHypervolume.WORSE(r.objectives[i], s.objectives[i]);
                vpq *= p.objectives[i];
                vpr *= z1;
                vps *= p.objectives[i];
                vqr *= r.objectives[i];
                vqs *= WFGHypervolume.WORSE(q.objectives[i], s.objectives[i]);
                vrs *= z2;
                vpqr *= z1;
                vpqs *= p.objectives[i];
                vprs *= z1;
                vqrs *= z2;
                vpqrs *= z1;
                continue;
            }
            if (WFGHypervolume.BEATS(p.objectives[i], s.objectives[i])) {
                vpq *= p.objectives[i];
                vpr *= p.objectives[i];
                vps *= s.objectives[i];
                vqr *= q.objectives[i];
                vqs *= s.objectives[i];
                vrs *= s.objectives[i];
                vpqr *= p.objectives[i];
                vpqs *= s.objectives[i];
                vprs *= s.objectives[i];
                vqrs *= s.objectives[i];
                vpqrs *= s.objectives[i];
                continue;
            }
            z1 = WFGHypervolume.WORSE(q.objectives[i], s.objectives[i]);
            vpq *= p.objectives[i];
            vpr *= p.objectives[i];
            vps *= p.objectives[i];
            vqr *= q.objectives[i];
            vqs *= z1;
            vrs *= WFGHypervolume.WORSE(r.objectives[i], s.objectives[i]);
            vpqr *= p.objectives[i];
            vpqs *= p.objectives[i];
            vprs *= p.objectives[i];
            vqrs *= z1;
            vpqrs *= p.objectives[i];
        }
        return vp + vq + vr + vs - vpq - vpr - vps - vqr - vqs - vrs + vpqr + vpqs + vprs + vqrs - vpqrs;
    }

    static double exclhv(Front ps, int p) {
        WFGHypervolume.makeDominatedBit(ps, p);
        double a2 = WFGHypervolume.inclhv(ps.points[p]);
        double b = WFGHypervolume.hv(fs[fr - 1]);
        double volume = a2 - b;
        --fr;
        return volume;
    }

    static double hv(Front ps) {
        switch (ps.nPoints) {
            case 1: {
                return WFGHypervolume.inclhv(ps.points[0]);
            }
            case 2: {
                double regreso = WFGHypervolume.inclhv2(ps.points[0], ps.points[1]);
                return regreso;
            }
            case 3: {
                return WFGHypervolume.inclhv3(ps.points[0], ps.points[1], ps.points[2]);
            }
            case 4: {
                return WFGHypervolume.inclhv4(ps.points[0], ps.points[1], ps.points[2], ps.points[3]);
            }
        }
        Arrays.sort(ps.points, 0, ps.nPoints, new ComparatorGreater());
        if (n == 2) {
            return WFGHypervolume.hv2(ps, ps.nPoints);
        }
        if (n == 3 && safe > 0) {
            double volume = ps.points[0].objectives[2] * WFGHypervolume.hv2(ps, safe);
            --n;
            for (int i = safe; i < ps.nPoints; ++i) {
                volume += ps.points[i].objectives[n] * WFGHypervolume.exclhv(ps, i);
            }
            ++n;
            return volume;
        }
        double volume = WFGHypervolume.inclhv4(ps.points[0], ps.points[1], ps.points[2], ps.points[3]);
        --n;
        for (int i = 4; i < ps.nPoints; ++i) {
            double a2 = ps.points[i].objectives[n];
            double b = WFGHypervolume.exclhv(ps, i);
            volume += a2 * b;
        }
        ++n;
        return volume;
    }

    private double hypervolume(org.uma.jmetal.util.legacy.front.Front front, org.uma.jmetal.util.legacy.front.Front referenceFront) {
        org.uma.jmetal.util.legacy.front.Front invertedFront = FrontUtils.getInvertedFront(front);
        int numberOfObjectives = referenceFront.getPoint(0).getDimension();
        return WFGHypervolume.CalculateHypervolume(FrontUtils.convertFrontToArray(invertedFront), invertedFront.getNumberOfPoints(), numberOfObjectives);
    }

    @Override
    public String getDescription() {
        return "PISA implementation of the hypervolume quality indicator";
    }

    @Override
    public List<S> computeHypervolumeContribution(List<S> solutionList, List<S> referenceFrontList) {
        if (solutionList.size() > 1) {
            ArrayFront front = new ArrayFront(solutionList);
            ArrayFront referenceFront = new ArrayFront(referenceFrontList);
            double[] maximumValues = FrontUtils.getMaximumValues(referenceFront);
            double[] minimumValues = FrontUtils.getMinimumValues(referenceFront);
            FrontNormalizer frontNormalizer = new FrontNormalizer(minimumValues, maximumValues);
            org.uma.jmetal.util.legacy.front.Front normalizedFront = frontNormalizer.normalize(front);
            double[] offsets = new double[maximumValues.length];
            for (int i = 0; i < maximumValues.length; ++i) {
                offsets[i] = this.offset / (maximumValues[i] - minimumValues[i]);
            }
            org.uma.jmetal.util.legacy.front.Front invertedFront = FrontUtils.getInvertedFront(normalizedFront);
            for (int i = 0; i < invertedFront.getNumberOfPoints(); ++i) {
                org.uma.jmetal.util.point.Point point = invertedFront.getPoint(i);
                for (int j = 0; j < point.getDimension(); ++j) {
                    point.setValue(j, point.getValue(j) + offsets[j]);
                }
            }
            HypervolumeContributionAttribute<Solution> hvContribution = new HypervolumeContributionAttribute<Solution>();
            double[] contributions = this.hvContributions(FrontUtils.convertFrontToArray(invertedFront));
            for (int i = 0; i < contributions.length; ++i) {
                hvContribution.setAttribute((Solution)solutionList.get(i), contributions[i]);
            }
            Collections.sort(solutionList, new HypervolumeContributionComparator());
        }
        return solutionList;
    }

    private double[] hvContributions(double[][] front) {
        int numberOfObjectives = front[0].length;
        double[] contributions = new double[front.length];
        double[][] frontSubset = new double[front.length - 1][front[0].length];
        LinkedList<double[]> frontCopy = new LinkedList<double[]>();
        Collections.addAll(frontCopy, front);
        double[][] totalFront = (double[][])frontCopy.toArray((T[])frontSubset);
        double totalVolume = WFGHypervolume.CalculateHypervolume(totalFront, totalFront.length, numberOfObjectives);
        for (int i = 0; i < front.length; ++i) {
            double contribution;
            double[] evaluatedPoint = (double[])frontCopy.remove(i);
            frontSubset = (double[][])frontCopy.toArray((T[])frontSubset);
            double hv = WFGHypervolume.CalculateHypervolume(frontSubset, frontSubset.length, numberOfObjectives);
            contributions[i] = contribution = totalVolume - hv;
            frontCopy.add(i, evaluatedPoint);
        }
        return contributions;
    }

    static {
        safe = 0;
        fr = 0;
    }

    static class Front {
        int nPoints;
        Point[] points;

        public Front(double[][] frente) {
            this.points = new Point[frente.length];
            this.nPoints = frente.length;
            for (int x = 0; x < frente.length; ++x) {
                this.points[x] = new Point(frente[0].length);
                for (int j = 0; j < frente[0].length; ++j) {
                    this.points[x].objectives[j] = frente[x][j];
                }
            }
        }
    }

    static class Point {
        double[] objectives;

        public Point(int size) {
            this.objectives = new double[size];
        }
    }

    static class ComparatorGreater
    implements Comparator<Point> {
        ComparatorGreater() {
        }

        @Override
        public int compare(Point p, Point q) {
            for (int i = n - 1; i >= 0; --i) {
                if (WFGHypervolume.BEATS(p.objectives[i], q.objectives[i])) {
                    return -1;
                }
                if (!WFGHypervolume.BEATS(q.objectives[i], p.objectives[i])) continue;
                return 1;
            }
            return 0;
        }
    }
}

