/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.observer.impl;

import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.chartcontainer.GenericChartContainer;
import org.uma.jmetal.util.observable.Observable;
import org.uma.jmetal.util.observer.Observer;

public class RunTimeChartObserver<S extends Solution<?>>
implements Observer<Map<String, Object>> {
    private GenericChartContainer<S> chart;
    private Integer evaluations;
    private int plotUpdateFrequency;

    public RunTimeChartObserver(String legend, int delay) {
        this(legend, delay, "");
    }

    public RunTimeChartObserver(String legend, int delay, String referenceFrontName) {
        this(legend, delay, 1, referenceFrontName);
    }

    public RunTimeChartObserver(String legend, int delay, int plotUpdateFrequency, String referenceFrontName) {
        this.plotUpdateFrequency = plotUpdateFrequency;
        this.chart = new GenericChartContainer(legend, delay);
        try {
            this.chart.setFrontChart(0, 1, referenceFrontName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.chart.initChart();
    }

    public void setReferencePoins(List<List<Double>> referencePoins) {
        this.chart.setReferencePoint(referencePoins);
    }

    public void setReferencePointList(List<List<Double>> referencePointList) {
        this.chart.setReferencePoint(referencePointList);
    }

    @Override
    public void update(Observable<Map<String, Object>> observable, Map<String, Object> data) {
        this.evaluations = (Integer)data.get("EVALUATIONS");
        List population = (List)data.get("POPULATION");
        if (this.evaluations != null && population != null) {
            if (this.chart != null && this.evaluations % this.plotUpdateFrequency == 0) {
                this.chart.getFrontChart().setTitle("Evaluation: " + this.evaluations);
                this.chart.updateFrontCharts(population);
                this.chart.refreshCharts();
            }
        } else {
            JMetalLogger.logger.warning(this.getClass().getName() + " : insufficient for generating real time information. Either EVALUATIONS or POPULATION keys have not been registered yet by the algorithm");
        }
    }

    public GenericChartContainer<S> getChart() {
        return this.chart;
    }

    public String getName() {
        return "Runtime chart observer";
    }

    public String toString() {
        return this.getName();
    }
}

