/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.point;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.point.Point;

public class PointSolution
implements Solution<Double> {
    private int numberOfObjectives;
    private double[] objectives;
    protected Map<Object, Object> attributes;

    @Override
    public List<Double> variables() {
        return null;
    }

    @Override
    public double[] objectives() {
        return this.objectives;
    }

    @Override
    public double[] constraints() {
        return null;
    }

    @Override
    public Map<Object, Object> attributes() {
        return this.attributes;
    }

    public PointSolution(int numberOfObjectives) {
        this.numberOfObjectives = numberOfObjectives;
        this.objectives = new double[numberOfObjectives];
        this.attributes = new HashMap<Object, Object>();
    }

    public PointSolution(Point point) {
        this.numberOfObjectives = point.getDimension();
        this.objectives = new double[this.numberOfObjectives];
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            this.objectives[i] = point.getValue(i);
        }
    }

    public PointSolution(Solution<?> solution) {
        this.numberOfObjectives = solution.objectives().length;
        this.objectives = new double[this.numberOfObjectives];
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            this.objectives[i] = solution.objectives()[i];
        }
    }

    public PointSolution(PointSolution point) {
        this(point.objectives().length);
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            this.objectives[i] = point.objectives()[i];
        }
    }

    public PointSolution copy() {
        return new PointSolution(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PointSolution that = (PointSolution)o;
        if (this.numberOfObjectives != that.numberOfObjectives) {
            return false;
        }
        return Arrays.equals(this.objectives, that.objectives);
    }

    public int hashCode() {
        return Arrays.hashCode(this.objectives);
    }

    public String toString() {
        return Arrays.toString(this.objectives);
    }
}

