/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.point.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.point.Point;

public class ArrayPoint
implements Point {
    protected double[] point;

    public ArrayPoint() {
        this.point = null;
    }

    public ArrayPoint(int dimension) {
        this.point = new double[dimension];
        Arrays.fill(this.point, 0.0);
    }

    public ArrayPoint(Point point) {
        Check.notNull(point);
        this.point = new double[point.getDimension()];
        for (int i = 0; i < point.getDimension(); ++i) {
            this.point[i] = point.getValue(i);
        }
    }

    public ArrayPoint(double[] point) {
        Check.notNull(point);
        this.point = new double[point.length];
        System.arraycopy(point, 0, this.point, 0, point.length);
    }

    public ArrayPoint(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        InputStreamReader isr = new InputStreamReader(fis);
        try (BufferedReader br = new BufferedReader(isr);){
            ArrayList<Double> auxiliarPoint = new ArrayList<Double>();
            String aux = br.readLine();
            while (aux != null) {
                StringTokenizer st = new StringTokenizer(aux);
                while (st.hasMoreTokens()) {
                    Double value = Double.valueOf(st.nextToken());
                    auxiliarPoint.add(value);
                }
                aux = br.readLine();
            }
            this.point = new double[auxiliarPoint.size()];
            for (int i = 0; i < auxiliarPoint.size(); ++i) {
                this.point[i] = (Double)auxiliarPoint.get(i);
            }
        }
    }

    @Override
    public int getDimension() {
        return this.point.length;
    }

    @Override
    public double[] getValues() {
        return this.point;
    }

    @Override
    public double getValue(int index) {
        Check.that(index >= 0 && index < this.point.length, "Index value invalid: " + index + ". The point length is: " + this.point.length);
        return this.point[index];
    }

    @Override
    public void setValue(int index, double value) {
        Check.that(index >= 0 && index < this.point.length, "Index value invalid: " + index + ". The point length is: " + this.point.length);
        this.point[index] = value;
    }

    @Override
    public void update(double[] point) {
        this.set(point);
    }

    @Override
    public void set(double[] point) {
        Check.that(point.length == this.point.length, "The point to be update have a dimension of " + point.length + " while the parameter point has a dimension of " + point.length);
        for (int i = 0; i < point.length; ++i) {
            this.point[i] = point[i];
        }
    }

    public String toString() {
        Object result = "";
        for (double anObjectives_ : this.point) {
            result = (String)result + anObjectives_ + " ";
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayPoint that = (ArrayPoint)o;
        return Arrays.equals(this.point, that.point);
    }

    public int hashCode() {
        return Arrays.hashCode(this.point);
    }
}

