/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.point.util.comparator;

import java.util.Comparator;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.point.Point;

public class PointDimensionComparator
implements Comparator<Point> {
    private int index;

    public PointDimensionComparator(int index) {
        if (index < 0) {
            throw new JMetalException("The index value is negative");
        }
        this.index = index;
    }

    @Override
    public int compare(Point pointOne, Point pointTwo) {
        if (pointOne == null) {
            throw new JMetalException("PointOne is null");
        }
        if (pointTwo == null) {
            throw new JMetalException("PointTwo is null");
        }
        if (this.index >= pointOne.getDimension()) {
            throw new JMetalException("The index value " + this.index + " is out of range (0,  " + (pointOne.getDimension() - 1) + ")");
        }
        if (this.index >= pointTwo.getDimension()) {
            throw new JMetalException("The index value " + this.index + " is out of range (0,  " + (pointTwo.getDimension() - 1) + ")");
        }
        return Double.compare(pointOne.getValue(this.index), pointTwo.getValue(this.index));
    }
}

