/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.sequencegenerator.impl;

import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.sequencegenerator.SequenceGenerator;

public class IntegerPermutationGenerator
implements SequenceGenerator<Integer> {
    private int[] sequence;
    private int index;
    private int size;

    public IntegerPermutationGenerator(int size) {
        Check.that(size > 0, "Size " + size + " is not a positive number greater than zero");
        this.size = size;
        this.sequence = this.randomPermutation(size);
        this.index = 0;
    }

    @Override
    public Integer getValue() {
        return this.sequence[this.index];
    }

    @Override
    public void generateNext() {
        ++this.index;
        if (this.index == this.sequence.length) {
            this.sequence = this.randomPermutation(this.size);
            this.index = 0;
        }
    }

    private int[] randomPermutation(int size) {
        int[] permutation = new int[size];
        JMetalRandom randomGenerator = JMetalRandom.getInstance();
        int[] index = new int[size];
        boolean[] flag = new boolean[size];
        for (int n = 0; n < size; ++n) {
            index[n] = n;
            flag[n] = true;
        }
        block1: for (int num = 0; num < size; ++num) {
            int start = randomGenerator.nextInt(0, size - 1);
            while (true) {
                if (flag[start]) {
                    permutation[num] = index[start];
                    flag[start] = false;
                    continue block1;
                }
                if (start == size - 1) {
                    start = 0;
                    continue;
                }
                ++start;
            }
        }
        return permutation;
    }

    @Override
    public int getSequenceLength() {
        return this.size;
    }
}

