/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.termination.impl;

import java.util.List;
import java.util.Map;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.util.NormalizeUtils;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.termination.Termination;

public class TerminationByQualityIndicator
implements Termination {
    private QualityIndicator qualityIndicator;
    private double[][] referenceFront;
    private double percentage;
    private double referenceFrontIndicatorValue;
    private int evaluationsLimit;
    private int evaluations;
    private boolean evaluationsLimitReached;
    private double computedIndicatorValue;

    public TerminationByQualityIndicator(QualityIndicator qualityIndicator, double[][] referenceFront, double percentage, int evaluationsLimit) {
        this.qualityIndicator = qualityIndicator;
        this.percentage = percentage;
        this.referenceFront = referenceFront;
        this.evaluationsLimit = evaluationsLimit;
        this.evaluations = 0;
        this.evaluationsLimitReached = false;
        double[][] normalizedReferenceFront = NormalizeUtils.normalize(referenceFront);
        qualityIndicator.setReferenceFront(normalizedReferenceFront);
        this.referenceFrontIndicatorValue = qualityIndicator.compute(normalizedReferenceFront);
    }

    @Override
    public boolean isMet(Map<String, Object> algorithmStatusData) {
        boolean successfulStopCondition;
        List population = (List)algorithmStatusData.get("POPULATION");
        this.evaluations = (Integer)algorithmStatusData.get("EVALUATIONS");
        Check.notNull(population);
        double[][] front = SolutionListUtils.getMatrixWithObjectiveValues(population);
        double[][] normalizedFront = NormalizeUtils.normalize(front, NormalizeUtils.getMinValuesOfTheColumnsOfAMatrix(this.referenceFront), NormalizeUtils.getMaxValuesOfTheColumnsOfAMatrix(this.referenceFront));
        this.computedIndicatorValue = this.qualityIndicator.compute(normalizedFront);
        boolean unsuccessfulStopCondition = this.evaluationsLimit <= this.evaluations;
        boolean bl = successfulStopCondition = this.computedIndicatorValue >= this.percentage * this.referenceFrontIndicatorValue;
        if (unsuccessfulStopCondition) {
            this.evaluationsLimitReached = true;
        }
        return successfulStopCondition || unsuccessfulStopCondition;
    }

    public double getComputedIndicatorValue() {
        return this.computedIndicatorValue;
    }

    public double getReferenceFrontIndicatorValue() {
        return this.referenceFrontIndicatorValue;
    }

    public double getEvaluations() {
        return this.evaluations;
    }

    public boolean evaluationsLimitReached() {
        return this.evaluationsLimitReached;
    }
}

